/****************************************
 *  COPYRIGHT (C) 2018, 2024
 *  Holger Graf
 ****************************************/
package siarchive.json.galaxy;

import java.io.IOException;
import java.util.Map;

import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;

import siarchive.tools.EscapeUtils;

/**
 * @author graf
 *
 */
public class UserBean {

    private long id;
    private String nickname;
    private String title;
    private Status status;
    private SpecializationBean spec;
    private long ranking;
    private long spice;
    private AllianceBean alliance;

    public UserBean() {}

    public long getId() {
        return id;
    }

    public void setId( long id ) {
        this.id = id;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname( String nickname ) {
        this.nickname = EscapeUtils.unescapeHtml4(nickname);
    }

    public Status getStatus() {
        return status;
    }

    public void setStatus( Object status ) {
        String[] all = status.toString().split("\\.", 2);
        this.status = Status.valueOf(all[0]);
        if(all.length > 1) {
            this.status.setSecondary(Status.valueOf(all[1]));
        }
    }

    public SpecializationBean getSpec() {
        return spec;
    }

    public void setSpec( SpecializationBean spec ) {
        this.spec = spec;
    }

    public long getRanking() {
        return ranking;
    }

    public void setRanking( long ranking ) {
        this.ranking = ranking;
    }

    public long getSpice() {
        return spice;
    }

    public void setSpice( long spice ) {
        this.spice = spice;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle( String title ) {
        this.title = title;
    }

    public AllianceBean getAlliance() {
        return alliance;
    }

    public void setAlliance( Object alliance ) throws JSONObjectException, IOException {
        this.alliance = null;
        if(alliance instanceof Map) {
            this.alliance = JSON.std.beanFrom(AllianceBean.class, JSON.std.asString(alliance));
        }
    }

}
