/****************************************
 *  COPYRIGHT (C) 2024
 *  Holger Graf
 ****************************************/
package siarchive.json.galaxy;

import java.util.LinkedHashMap;

/**
 *
 */
public class SpecializationBean extends LinkedHashMap<String, Integer> {

    private static final long serialVersionUID = 7058505085642048651L;

    public String getSpecialization() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ")
          .append(getSpecValue("0"))
          .append(" | ")
          .append(getSpecValue("1"))
          .append(" | ")
          .append(getSpecValue("2"))
          .append(" | ")
          .append(getSpecValue("3"))
          .append(" ]");
        return sb.toString();
    }

    private int getSpecValue(String key) {
        int rv = 0;
        if(containsKey(key)) {
            rv = get(key).intValue();
        }
        return rv;
    }
}
