/****************************************
 *  COPYRIGHT (C) 2024
 *  Holger Graf
 ****************************************/
package siarchive.json.galaxy;

import java.util.LinkedHashMap;

import siarchive.components.Resource;

/**
 *
 */
public class RubbleFieldBean extends LinkedHashMap<String, Long> {

    private static final long serialVersionUID = 3080026084740965542L;

    public long getIron() {
        return getResource(Resource.iron);
    }

    public long getMetal() {
        return getResource(Resource.metal);
    }

    public long getKryptonite() {
        return getResource(Resource.kryptonite);
    }

    public long getSpice() {
        return getResource(Resource.spice);
    }

    private long getResource(Resource resource) {
        long rv = 0;
        String key = Integer.toString(resource.ordinal());
        if(containsKey(key)) {
            rv = get(key).longValue();
        }
        return rv;
    }
}
