/****************************************
 *  COPYRIGHT (C) 2023
 *  Holger Graf
 ****************************************/
package siarchive.json.galaxy;

import java.util.LinkedHashMap;
import java.util.List;

import siarchive.components.Position;
import siarchive.galaxy.PositionSet;

/**
 *
 */
public class PlanetVisibility extends LinkedHashMap<String, List<String>>{

    private static final long serialVersionUID = 7288070583105797490L;

    public PositionSet getSystem(Position system) {
        PositionSet positionSet = new PositionSet();
        List<String> planets = get(system.toString());
        if(planets != null) {
            for(String planet : planets)
                positionSet.add(Position.createFromId(Position.createId(planet)));
        }
        return positionSet;
    }
}
