/****************************************
 *  COPYRIGHT (C) 2018
 *  Holger Graf
 ****************************************/
package siarchive.json.galaxy;

import java.io.IOException;
import java.util.Map;

import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;

import siarchive.tools.EscapeUtils;

/**
 * @author graf
 *
 */
public class PlanetBean {


    private boolean isEventPlanet;
    private int id;
    private int position;
    private int temperature;
    private String coords;
    private String name;
    private String image;
    private UserBean user;
    private RubbleFieldBean rubblefield;
    private boolean hasAstro;

    public PlanetBean() {}

    public boolean isIsEventPlanet() {
        return isEventPlanet;
    }

    public void setIsEventPlanet( boolean isEventPlanet ) {
        this.isEventPlanet = isEventPlanet;
    }

    public int getId() {
        return id;
    }

    public void setId( int id ) {
        this.id = id;
    }

    public int getPosition() {
        return position;
    }

    public void setPosition( int position ) {
        this.position = position;
    }

    public int getTemperature() {
        return temperature;
    }

    public void setTemperature( int temperature ) {
        this.temperature = temperature;
    }

    public String getCoords() {
        return coords;
    }

    public void setCoords( String coords ) {
        this.coords = coords;
    }

    public String getName() {
        return name;
    }

    public void setName( String name ) {
        this.name = EscapeUtils.unescapeHtml4(name);
    }

    public String getImage() {
        return image;
    }

    public void setImage( String image ) {
        this.image = image;
    }

    public UserBean getUser() {
        return user;
    }

    public void setUser( Object user ) throws JSONObjectException, IOException {
        this.user = null;
        if(user instanceof Map) {
            this.user = JSON.std.beanFrom(UserBean.class, JSON.std.asString(user));
        }
    }

    public RubbleFieldBean getRubblefield() {
        return rubblefield;
    }

    public void setRubblefield( RubbleFieldBean rubblefield ) {
        this.rubblefield = rubblefield;
    }

    public boolean isHasAstro() {
        return hasAstro;
    }

    public void setHasAstro( boolean hasAstro ) {
        this.hasAstro = hasAstro;
    }

}
