/****************************************
 *  COPYRIGHT (C) 2018
 *  Holger Graf
 ****************************************/
package siarchive.json.galaxy;

import java.io.IOException;
import java.util.Map;

import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;

import datatransfer.json.InfoBean;


/**
 * @author graf
 *
 */
public class GalaxyBean {

    private InfoBean info;
    private BlackHoleBean hole;
    private PositionBean position;
    private Map<String, PlanetBean> planets;

    public GalaxyBean() {}

    public InfoBean getInfo() {
        return info;
    }

    public void setInfo( InfoBean info ) {
        this.info = info;
    }

    public PositionBean getPosition() {
        return position;
    }

    public void setPosition( PositionBean position ) {
        this.position = position;
    }

    public BlackHoleBean getHole() {
        return hole;
    }

    public void setHole( Object hole ) throws JSONObjectException, IOException {
        this.hole = null;
        if(hole instanceof Map) {
            this.hole = JSON.std.beanFrom(BlackHoleBean.class, JSON.std.asString(hole));
        }
    }

    public Map<String, PlanetBean> getPlanets() {
        return planets;
    }

    public void setPlanets( Map<String, PlanetBean> planets ) {
        this.planets = planets;
    }

}
