/****************************************
 *  COPYRIGHT (C) 2018
 *  Holger Graf
 ****************************************/
package siarchive.json.battlereport;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;

import datatransfer.json.InfoBean;


/**
 * @author graf
 *
 */
public class BattleReportBean {

    private InfoBean info;
    private long reportID;
    private String allianceAttackMember;
    private PlanetBean startPlanet;
    private PlanetBean destinationPlanet;
    private FighterBean attacker;
    private FighterBean defender;
    private String winner;
    private DestroyedBean destroyed;
    private List<Long> rubblefield;
    private StolenBean stolen;
    // firstStrike is either a Boolean or a FirstStrikeBean
    private FirstStrikeBean firstStrike;
    private Map<String, RoundBean> rounds;
    private AstroBean astro;
    private String insertDate;
    private long timestamp;


    public BattleReportBean() {}


    public InfoBean getInfo() {
        return info;
    }


    public void setInfo( InfoBean info ) {
        this.info = info;
    }


    public long getReportID() {
        return reportID;
    }


    public void setReportID( long reportID ) {
        this.reportID = reportID;
    }


    public String getAllianceAttackMember() {
        return allianceAttackMember;
    }


    public void setAllianceAttackMember( String allianceAttackMember ) {
        this.allianceAttackMember = allianceAttackMember;
    }


    public PlanetBean getStartPlanet() {
        return startPlanet;
    }


    public void setStartPlanet( PlanetBean startPlanet ) {
        this.startPlanet = startPlanet;
    }


    public PlanetBean getDestinationPlanet() {
        return destinationPlanet;
    }


    public void setDestinationPlanet( PlanetBean destinationPlanet ) {
        this.destinationPlanet = destinationPlanet;
    }


    public FighterBean getAttacker() {
        return attacker;
    }


    public void setAttacker( FighterBean attacker ) {
        this.attacker = attacker;
    }


    public FighterBean getDefender() {
        return defender;
    }


    public void setDefender( FighterBean defender ) {
        this.defender = defender;
    }


    public String getWinner() {
        return winner;
    }


    public void setWinner( String winner ) {
        this.winner = winner;
    }


    public DestroyedBean getDestroyed() {
        return destroyed;
    }


    public void setDestroyed( DestroyedBean destroyed ) {
        this.destroyed = destroyed;
    }


    public List<Long> getRubblefield() {
        return rubblefield;
    }


    public void setRubblefield( List<Long> rubblefield ) {
        this.rubblefield = rubblefield;
    }


    public StolenBean getStolen() {
        return stolen;
    }


    public void setStolen( StolenBean stolen ) {
        this.stolen = stolen;
    }


    public FirstStrikeBean getFirstStrike() {
        return firstStrike;
    }


    public void setFirstStrike( Object firstStrike ) throws JSONObjectException, IOException {
        this.firstStrike = null;
        if(firstStrike instanceof Map) {
            this.firstStrike = JSON.std.beanFrom(FirstStrikeBean.class, JSON.std.asString(firstStrike));
        }
    }


    public Map<String, RoundBean> getRounds() {
        return rounds;
    }


    public void setRounds( Map<String, RoundBean> rounds ) {
        this.rounds = rounds;
    }


    public AstroBean getAstro() {
        return astro;
    }


    public void setAstro( AstroBean astro ) {
        this.astro = astro;
    }


    public String getInsertDate() {
        return insertDate;
    }


    public void setInsertDate( String insertDate ) {
        this.insertDate = insertDate;
    }


    public long getTimestamp() {
        return timestamp;
    }


    public void setTimestamp( long timestamp ) {
        this.timestamp = timestamp;
    }


}
