/****************************************
 *  COPYRIGHT (C) 2011
 *  Holger Graf
 ****************************************/
package siarchive.init;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

import siarchive.persistence.DatabaseFactory;
import siarchive.persistence.SQLParser;

/**
 * @author graf
 *
 */
public class Init
{

    /**
     * @param args
     */
    public static void main( String[] args )
    {
        if(args.length < 1)
        {
            System.out.println("Init <filename> [ignoreSQLErrors]");
        }
        else
        {
            boolean ignoreSQLErrors = false;
            if(args.length > 1) {
                if( "ignoreSQLErrors".equals( args[1] ) 
                || 'y' == args[1].charAt( 0 )
                || 'Y' == args[1].charAt( 0 ) )
                {
                    ignoreSQLErrors = true;
                }
            }
            try
            {
                // read properties
                DatabaseFactory.open();
                Connection connection = DatabaseFactory.getConnection();
                
                // (re-)create tables
                Statement statement = connection.createStatement();
                
                SQLParser parser = new SQLParser( args[0] );
                String sql = null;
                while( (sql = parser.getNextStatement()) != null )
                {
                    System.out.println("executing " + sql);
                    try
                    {
                        statement.execute( sql );
                    }
                    catch( SQLException e)
                    {
                        if(ignoreSQLErrors)
                        {
                            System.out.println("SQLException " +  e.getMessage() + " ignored");
                        }
                        else
                        {
                            throw e;
                        }
                    }
                }
                
                // make it real
                DatabaseFactory.commit();
    
            }
            catch( SQLException ex)
            {
                ex.printStackTrace( System.err );
                try
                {
                    DatabaseFactory.rollback();
                }
                catch( SQLException ex1 )
                {
                    ex1.printStackTrace();
                }
            }
            catch( FileNotFoundException e )
            {
                System.err.println("cannot open file " + args[0]);
            }
            catch( IOException ex )
            {
                ex.printStackTrace( System.err );
            }
            finally
            {
                // close DB connection
                DatabaseFactory.close();
            }
        }
    }

}
