/****************************************
 *  COPYRIGHT (C) 2010
 *  Holger Graf
 ****************************************/

package siarchive.imports;

import java.io.IOException;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.fasterxml.jackson.jr.ob.JSON;
import siarchive.DataManager;
import siarchive.components.Position;
import siarchive.datatransfer.JsonScanner;
import siarchive.json.JSONTags;
import siarchive.json.galaxy.GalaxyBean;

/**
 * @author graf
 *
 */
public class GalaxyImporterNT
{
    private DataManager dataManager;

    private Pattern areaPattern = Pattern.compile( "<\\s*textarea.*?>(.*?)</\\s*textarea>", Pattern.DOTALL );


    public GalaxyImporterNT( DataManager dataManager )
    {
        this.dataManager = dataManager;
    }

    public Position scan( String input ) throws SQLException
    {
        if(input.indexOf("textarea") >= 0) {
            // HTML source input
            Matcher areaMatcher = areaPattern.matcher( input );
            while( areaMatcher.find() ) {
                input = areaMatcher.group( 1 );
                if(input.indexOf(JSONTags.reportType_GalaxyOverview) >= 0) {
                    return scanJSON(input);
                }
            }
        }
        else {
            // clean JSON input
            return scanJSON(input);
        }
        return new Position(0, 0, 0);
    }

    private Position scanJSON( String input ) throws SQLException {
        int galaxy = 0;
        int system = 0;
        try {
            GalaxyBean galaxyBean = JSON.std.beanFrom(GalaxyBean.class, input);
            Position position = JsonScanner.scanGalaxyJSON(galaxyBean, dataManager);
            galaxy = position.getGalaxy();
            system = position.getSystem();
        }
        catch( IOException e1 ) {
            e1.printStackTrace();
        }
        return new Position( galaxy, system, 1 );
    }

}
