/****************************************
 *  COPYRIGHT (C) 2010
 *  Holger Graf
 ****************************************/

package siarchive.imports;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

/**
 * @author graf
 *
 */
public class DateParser
{
	private static SimpleDateFormat parser = new SimpleDateFormat( "yyy-MM-dd HH:mm:ss");
	
	public static Pattern datePattern = Pattern.compile( "\\d+-\\d+-\\d+\\s+\\d+:\\d+:\\d+", Pattern.MULTILINE );
	
	public static long parse( String date )
	{
		long result = 0;
		try
		{
			result = parser.parse( date ).getTime();
		}
		catch (ParseException e)
		{
			e.printStackTrace();
		}
		return result;
	}
	
	public static String format( long date )
	{
	    return parser.format( new Date( date ) );
	}
}
