/****************************************
 *  COPYRIGHT (C) 2008-2024
 *  Holger Graf
 ****************************************/
package siarchive.i18n;

import java.util.ListResourceBundle;

import siarchive.components.AttackStatus;
import siarchive.components.BlackHoleLevel;
import siarchive.components.Building;
import siarchive.components.Defense;
import siarchive.components.Flavor;
import siarchive.components.Research;
import siarchive.components.Resource;
import siarchive.components.SearchOption;
import siarchive.components.Ship;
import siarchive.components.Status;

/**
 * @author graf
 *
 */
public class Messages_ru extends ListResourceBundle
{
    // I'm less than impressed with the .properties handling (especially this native2ascii thingie),
    // lets try this
    private static final Object[][] contents =
    {
        // controls
        { "OK", "OK" },
        { "Close", "Закрыть" },
        { "New", "Новый" },
        { "Load", "Загрузить..." },
        { "Save", "Сохранить..." },
        { "Import", "Загрузить..." },
        { "load", "{0} Загрузить" },
        { "save", "{0} Сохранить" },
        { "file.exists", "Файл существует. Продолжить сохранение?" },
        { "confirm.overwrite", "Подтверждение Сохранения" },
        { "Compute", "Вычислить" },
        { "Warning", "Внимание!" },
        { "Error", "Error" },
        { "Really.quit", "Закончить без Сохранения?" },
        { "Planet", "Планета" },
        { "Asteroid", "Астероид" },
        { "Building", "Здание" },
        { "Temperature", "Температура" },
        { "Level", "Уровень" },
        { "max.Level", "макс. Уровень" },
        { "WeaponsFact.level", "{0}" },
        { "DevC.level", "Центр разработок" },
        { "Msa.level", "МСУ" },
        { "Thermo", "Термо-сол. фаб." },
        { "day.symbol", "Д" },
        { "add", "Добавить" },
        { "delete", "Удалить выбранный" },
        { "deleteAll", "Удалить все" },
        { "export", "Сохранить выбранный..." },
        { "exportAll", "Сохранить все..." },
        // enums
        // Language
        { Language.german.name(), "немецкий" },
        { Language.english.name(), "английский" },
        { Language.russian.name(), "русский" },
        // Status
        { Status.none.name(), "" },
        { Status.noob.name(), "Покровительство" },
        { Status.vacation.name(), "Режим выходных дней" },
        { Status.inactive.name(), "Неактивен" },
        { Status.enemy.name(), "Враг" },
        { Status.strong.name(), "Сильный" },
        { Status.operator.name(), "Оператор игры" },
        { Status.locked.name(), "locked" },
        { Status.alliance.name(), "Член Альянса" },
        { Status.wing.name(), "Основной/подразделение" },
        { Status.bnd.name(), "Союзники" },
        { Status.nap.name(), "Пакт о ненападении" },
        { Status.spectral.name(), "Spectral" },
        // Building
        { Building.ironMine.name(), "Рудодобывающая шахта" },
        { Building.furnace.name(), "Рудообрабатывающий завод" },
        { Building.kryptoniteMine.name(), "Криптонитовая шахта" },
        { Building.spiceMine.name(), "Шахта спайса" },
        { Building.fusionPlant.name(), "Электростанция" },
        { Building.thermosolarPlant.name(), "Термо-солнечная фабрика" },
        { Building.developmentCenter.name(), "Центр разработок" },
        { Building.researchLab.name(), "Исследовательская лаборатория" },
        { Building.weaponsFactory.name(), "Оружейный завод" },
        { Building.fleetBase.name(), "Военная база флота" },
        { Building.ironStorage.name(), "Склад руды" },
        { Building.metalStorage.name(), "Склад металла" },
        { Building.kryptoniteStorage.name(), "Склад криптонита" },
        { Building.spiceStorage.name(), "Склад спайса" },
        { Building.particleCannon.name(), "Энергетическая пушка" },
        { Building.particleShield.name(), "Энергетический щит" },
        { Building.msa.name(), "Микро-системный ускоритель" },
        { Building.teleporter.name(), "Телепорт" },
        { Building.scanner.name(), "Сканирующее устройство галактик" },
        // defense
        { Defense.mortar.name(), "Миномёт" },
        { Defense.turboFlak.name(), "Зенитная пушка" },
        { Defense.gravitonCannon.name(), "Лёгкие гравитоновые пушки" },
        { Defense.heavyGravitonCannon.name(), "Тяжёлые гравитоновые пушки" },
        { Defense.ionGun.name(), "Ионовое оружие" },
        { Defense.positronLighter.name(), "Позитроновая пушка" },
        { Defense.intervalCannon.name(), "Интервальная пушка" },
        { Defense.laserBattery.name(), "Батарея лазерных пушек" },
        { Defense.solarGun.name(), "Солнечное оружие" },
        { Defense.smallShieldDome.name(), "Малый защитный купол" },
        { Defense.largeShieldDome.name(), "Большой защитный купол" },
        // Research
        { Research.mining.name(), "Техника для шахт" },
        { Research.energytech.name(), "Энерго-техника" },
        { Research.drive.name(), "Исследования двигателя" },
        { Research.rocket.name(), "Ракетный двигатель" },
        { Research.diffusion.name(), "Диффузный двигатель" },
        { Research.warp.name(), "Варп-двигатель" },
        { Research.espionage.name(), "Средства шпионажа" },
        { Research.weapons.name(), "Усовершенствования для оружие" },
        { Research.shields.name(), "Усовершенствования для щита" },
        { Research.structure.name(), "Оборонительные системы" },
        { Research.target.name(), "Системы наведения" },
        { Research.particle.name(), "Анализатор частиц" },
        { Research.graviton.name(), "Гравитационная техника" },
        { Research.teleportation.name(), "Телепортация" },
        { Research.blackhole.name(), "Исследование чёрной дыры" },
        // Resource
        { Resource.iron.name(), "Руда" },
        { Resource.metal.name(), "Металл" },
        { Resource.kryptonite.name(), "Криптонит" },
        { Resource.spice.name(), "Спайс" },
        { Resource.energy.name(), "Энергия" },
        // ship
        { Ship.none.name(), "" },
        { Ship.smallTransport.name(), "Небольшой транспортер" },
        { Ship.largeTransport.name(), "Большой транспортер" },
        { Ship.transmitter.name(), "Трансмиттер" },
        { Ship.smallFighter.name(), "Маленький охотник" },
        { Ship.manOWar.name(), "Смерч" },
        { Ship.starCruiser.name(), "Звёздный Корсар" },
        { Ship.phoenix.name(), "Феникс" },
        { Ship.colonyShip.name(), "Корабль-колония" },
        { Ship.solarCell.name(), "Солнечный спутник" },
        { Ship.probe.name(), "Разведовательный зонд" },
        { Ship.recycler.name(), "Рециркулятор" },
        { Ship.battleship.name(), "Звёздный Эсминец" },
        { Ship.stealthBomber.name(), "Бомбардировщик-невидимка" },
        { Ship.destroyer.name(), "Дредноут" },
        { Ship.imperialStarbase.name(), "Звёздный корсар" },
        // Flavor
        { Flavor.nexus.name(), "Nexus" },
        { Flavor.retro.name(), "Retro" },
        { Flavor.sirius.name(), "Sirius" },
        { Flavor.genesis.name(), "GeNeSIS 2527" },
        { Flavor.solaris.name(), "Dark Gate" },
        { Flavor.speed.name(), "Speed" },
        { Flavor.infinity.name(), "Infinity" },
        // search options
        { SearchOption.attacker.name(), "нападающим" },
        { SearchOption.defender.name(), "защищающимся" },
        { SearchOption.players.name(), "игрокам" },
        { SearchOption.alliances.name(), "альянсам" },
        { SearchOption.planets.name(), "планетам" },
        { SearchOption.points.name(), "очкам" },
        { SearchOption.systems.name(), "системам" },
        { SearchOption.time.name(), "времени" },
        { SearchOption.attackstatus.name(), "cтатусу атакованный" },
        { SearchOption.level.name(), "уровню" },
        { "Search.search", "Искать по" },
        { "Search.searchCommand", "Искать" },
        // MainFrame
        { "MainFrame.menu.file", "Файл" },
        { "MainFrame.menu.file.mnemonic", "Ф" },
        { "MainFrame.menu.file.importDb", "DB Импорт..." },
        { "MainFrame.menu.file.importDb.mnemonic", "И" },
        { "MainFrame.menu.file.exportDb", "DB Экспорт..." },
        { "MainFrame.menu.file.exportDb.mnemonic", "Э" },
        { "MainFrame.menu.file.exit", "Закрыть" },
        { "MainFrame.menu.file.exit.mnemonic", "З" },
        { "MainFrame.menu.skins", "Скины" },
        { "MainFrame.menu.skins.mnemonic", "С" },
        { "MainFrame.menu.skins.restart", "Требуется перезагрузка" },
        { "MainFrame.menu.skins.restart.text", "Данное изменение требует перезагрузки программы. Продолжать?" },
        { "MainFrame.menu.tools", "Сервис" },
        { "MainFrame.menu.tools.mnemonic", "T" },
        { "MainFrame.menu.tools.galaxy", "Галактика" },
        { "MainFrame.menu.tools.galaxy.mnemonic", "Г" },
        { "MainFrame.menu.tools.datatransfer", "Обмен данных" },
        { "MainFrame.menu.tools..datatransfer.mnemonic", "О" },
        { "MainFrame.menu.tools.datatransfer.grabClipboard", "Hijack Clipboard" },
        { "MainFrame.menu.tools.datatransfer.grabClipboard.mnemonic", "C" },
        { "MainFrame.menu.tools.datatransfer.http", "Web Server" },
        { "MainFrame.menu.tools.datatransfer.http.mnemonic", "W" },
        { "MainFrame.menu.tools.import", "Импорт..." },
        { "MainFrame.menu.tools.import.mnemonic", "И" },
        { "MainFrame.menu.tools.export", "Экспорт" },
        { "MainFrame.menu.tools.export.mnemonic", "Э" },
        { "MainFrame.menu.tools.export.battle", "Отчёты по сражению..." },
        { "MainFrame.menu.tools.export.battle.mnemonic", "с" },
        { "MainFrame.menu.tools.export.blackhole", "Чёрные дыры..." },
        { "MainFrame.menu.tools.export.blackhole.mnemonic", "Ч" },
        { "MainFrame.menu.tools.export.planet", "Планеты..." },
        { "MainFrame.menu.tools.export.planet.mnemonic", "П" },
        { "MainFrame.menu.tools.export.spy", "Отчёты по шпионажу..." },
        { "MainFrame.menu.tools.export.spy.mnemonic", "ш" },
        { "MainFrame.menu.tools.fonts", "Шрифт..." },
        { "MainFrame.menu.tools.fonts.mnemonic", "Ш" },
        { "MainFrame.menu.help", "Помощь" },
        { "MainFrame.menu.help.mnemonic", "П" },
        { "MainFrame.menu.help.help", "Помощь..." },
        { "MainFrame.menu.help.help.mnemonic", "П" },
        { "MainFrame.menu.help.info", "Инфо..." },
        { "MainFrame.menu.help.info.mnemonic", "И" },
        { "MainFrame.account", "Профиль" },
        { "MainFrame.accounts", "Ваши Профили..." },
        { "MainFrame.blackholes", "Чёрные дыры" },
        { "MainFrame.players", "Игроки" },
        { "MainFrame.planets", "Планеты" },
        { "MainFrame.battleReports", "Отчёты по сражению" },
        { "MainFrame.spyReports", "Отчёты по шпионажу" },
        //help
        { "Help.title", "Помощь по {0}" },
        { "Help.url", "/help_ru.html" },
        // account
        { "Account.title", "Ваши Профили" },
        { "Account.name", "Название Профиля" },
        { "Account.isdefault", "Основной" },
        { "Account.language", "Язык" },
        { "Account.version", "Версия" },
        { "Account.outpost", "Outpost" },
        { "Account.create", "Добавить Профиль" },
        { "Account.remove.selected", "Удалить" },
        { "Account.already.exists", "Данный профиль уже создан!" },
        { "Account.unsaved.data", "Данные Профиля не Сохранены. Закончить без Сохранения?" },
        { "Account.language.nomatch", "Язык или версия профиля не совпадает!" },
        { "Account.name.nomatch", "Название профиля не совпадает. Продолжить?" },
        { "Version.nomatch", "Версия для импорта ({0}) слишком старая. \nВозможно, она не содержит всех необходимых данных. \nПродолжить?" },
        // galaxy view
        { "GalaxyView.sun", "Солнце" },
        // import
        { "ImportFrame.spyMarker", "Отчёт\\s*по\\s*шпионажу\\s*от" },
        { "ImportFrame.battleMarker", "Следующие\\s*карали\\s*флота\\s*противостоят\\s*друг\\s*другу" },
        { "ImportFrame.galaxyMarker", "Солнце" },
        { "ImportFrame.galaxyMarker.owner", "Владелец" },
        { "ImportFrame.galaxyMarker.points", "пункта" },
        { "ImportFrame.galaxyMarker.position", "Положение" },
        { "ImportFrame.galaxyMarker.alliance", "Альянс" },
        { "ImportFrame.galaxyMarker.status", "Статус" },
        { "ImportFrame.galaxyMarker.end", "Инфо\\sЗакрыть" },
        { "Import.retry", "Не удалось импортировать. Пожалуйста, попробуйте еще раз." },
        // battle report
        { "BattleReport.battleReport", "Отчёт по сражению" },
        { "BattleReport.attacker", "Нападающий" },
        { "BattleReport.defender", "Защищающийся" },
        { "BattleReport.round", "РАУНД" },
        { "BattleReport.firstStrike", "STEALTH BOMBER FIRST STRIKE" },
        { "BattleReport.destroyed", "УНИЧТОЖИТЬ" },
        { "BattleReport.damage", "Оружие" },
        { "BattleReport.shield", "Щит" },
        { "BattleReport.structure", "Оборона" },
        { "BattleReport.shields", "Schield" },
        { "BattleReport.firepower", "Firepower" },
        { "BattleReport.type", "Тип" },
        { "BattleReport.number", "Кол-во" },
        { "BattleReport.numberBefore", "Кол-во до" },
        { "BattleReport.numberAfter", "Кол-во после" },
        { "BattleReport.bomber", "Stealth bomber" },
        { "BattleReport.bomberResult", "The stealth bomber destroyed {0} оборонительных сооружений(я)." },
        { "BattleReport.attacking", "Атакующий" },
        { "BattleReport.defending", "Обороняющийся" },
        { "BattleReport.attackMessage", "{0} флот стреляет с силой выстрела {1} ед. ущерба." },
        { "BattleReport.shieldMessage", "{0} флот поглощает из этого {1} ед. ущерба." },
        { "BattleReport._attacker", "Атакующий" },
        { "BattleReport._defender", "Обороняющийся " },
        { "BattleReport.winMessage", "{0}выиграл битву!" },
        { "BattleReport.drawMessage", "Битва закончилась ничьей, атакующий флот возвращается на родную планету!" },
        { "BattleReport.plunder", "Он захватывает {0} руду, {1} металл, {2} криптонит, {3} спайс." },
        { "BattleReport.loss", "{0} потерял всего {1} единиц." },
        { "BattleReport.rubble", "На этих космических координатах сейчас находится больше {0} металла и {1} kryptonite." },
        { "BattleReport.astrochance", "Шансы образования астероида составляют {0}%" },
        { "BattleReport.asteroid", "An asteroid formed out of the rubble!" },
        // spy report
        { "SpyReport.spyreport", "Отчёт по шпионажу" },
        { "SpyReport.header", "Отчёт по шпионажу от" },
        { "SpyReport.from", "от" },
        { "SpyReport.buildings", "Постройки" },
        { "SpyReport.defense", "Оборона" },
        { "SpyReport.ships", "Флот" },
        { "SpyReport.research", "Исследования" },
        { "SpyReport.counterespionage", "Шансы на защиту от шпионажа:" },
        { "Report.time", "Время" },
        { "Report.priority", "" },
        { "Report.attacker", "Нападающий" },
        { "Report.defender", "Защищающийся" },
        // galaxy view
        { "GalaxyView.uninhabited", "Необитаемая планета" },
        { "GalaxyView.owner", "Владелец" },
        { "GalaxyView.specialization", "Специализация" },
        { "GalaxyView.points", "Пункты" },
        { "GalaxyView.spiceValue", "Спайс" },
        { "GalaxyView.position", "Положение" },
        { "GalaxyView.temperature", "Температура" },
        { "GalaxyView.alliance", "Альянс" },
        { "GalaxyView.status", "Статус" },
        { "GalaxyView.debris", "Обломки" },
        { "GalaxyView.lastUpdated", "Обновлен" },
        // planet view
        { "PlanetView.coords", "Планета" },
        { "Popup.show", "Показать" },
        { "Popup.showPlayer", "Показать игрока" },
        { "Popup.showAlliance", "Показать альянс" },
        { "Popup.showSystem", "Показать систему" },
        { "Popup.goto", "Перейти" },
        { "Popup.spyReports", "Отчёты по шпионажу" },
        { "Popup.battleReports", "Отчёты по сражению" },
        // DB info
        { "MainFrame.menu.tools.dbInfo", "Инфо о DB..." },
        { "MainFrame.menu.tools.dbInfo.mnemonic", "И" },
        { "DbInfo.config", "Файл конфигурации" },
        { "DbInfo.dbpath", "База данных" },
        { "DbInfo.contents", "Содержание профиля" },
        { "DbInfo.alliances", "Альянсы" },
        { "DbInfo.blackHoles", "Чёрные дыры" },
        { "DbInfo.players", "Игроки" },
        { "DbInfo.planets", "Планеты" },
        { "DbInfo.spyReports", "Отчёты по шпионажу" },
        { "DbInfo.battleReports", "Отчёты по сражению" },
        // notes
        { "NoteBox.title", "Примечания" },
        // black holes
        { "BlackHole.attacked", "Атакованный" },
        { "BlackHole.coords", "Координаты" },
        { "BlackHole.level", "Уровень" },
        { "BlackHole.power", "Атакующая сила" },
        { "BlackHole.ships", "Требуемый флот" },
        { "BlackHole.rewards", "Вознаграждение" },
        { "BlackHole.rewards.emblems", "Эмблемы" },
        { "BlackHole.rewards.stars", "Звезды" },
        { AttackStatus.all.name(), "все" },
        { AttackStatus.attacked.name(), "атакованные" },
        { AttackStatus.notattacked.name(), "не атакованные" },
        { BlackHoleLevel.all.name(), "все" },
        { BlackHoleLevel.white.name(), "белый" },
        { BlackHoleLevel.green.name(), "зелёный" },
        { BlackHoleLevel.blue.name(), "синий" },
        { BlackHoleLevel.red.name(), "красный" },
    };

    @Override
    protected Object[][] getContents()
    {
        return contents;
    }

}
