/****************************************
 *  COPYRIGHT (C) 2008-2024
 *  Holger Graf
 ****************************************/
package siarchive.i18n;

import java.util.ListResourceBundle;

import siarchive.components.AttackStatus;
import siarchive.components.BlackHoleLevel;
import siarchive.components.Building;
import siarchive.components.Defense;
import siarchive.components.Flavor;
import siarchive.components.Research;
import siarchive.components.Resource;
import siarchive.components.SearchOption;
import siarchive.components.Ship;
import siarchive.components.Status;

/**
 * @author graf
 *
 */
public class Messages_en extends ListResourceBundle
{
    // I'm less than impressed with the .properties handling (especially this native2ascii thingie),
    // lets try this
    private static final Object[][] contents =
    {
        // controls
        { "OK", "OK" },
        { "Close", "Close" },
        { "New", "New" },
        { "Load", "Load..." },
        { "Save", "Save..." },
        { "Import", "Import..." },
        { "load", "load {0}" },
        { "save", "save {0}" },
        { "file.exists", "File already exists. Overwrite?" },
        { "confirm.overwrite", "Confirm overwrite" },
        { "Compute", "Calculate" },
        { "Warning", "Warning" },
        { "Error", "Error" },
        { "Really.quit", "Really quit?" },
        { "Planet", "Planet" },
        { "Asteroid", "Asteroid" },
        { "Building", "Building" },
        { "Temperature", "Temperature" },
        { "Level", "Level" },
        { "max.Level", "max. Level" },
        { "WeaponsFact.level", "{0} level" },
        { "DevC.level", "DC level" },
        { "Msa.level", "MSA level" },
        { "Thermo", "Thermosolar plant" },
        { "day.symbol", "D" },
        { "add", "Add" },
        { "delete", "Remove selected" },
        { "deleteAll", "Remove all" },
        { "export", "Export selected..." },
        { "exportAll", "Export all..." },
        // enums
        // Language
        { Language.german.name(), "german" },
        { Language.english.name(), "english" },
        { Language.russian.name(), "russian" },
        // Status
        { Status.none.name(), "" },
        { Status.noob.name(), "Under newbie protection" },
        { Status.vacation.name(), "In vacation mode" },
        { Status.inactive.name(), "Inactive" },
        { Status.enemy.name(), "Hostile" },
        { Status.strong.name(), "Strong" },
        { Status.operator.name(), "Game operator" },
        { Status.locked.name(), "locked" },
        { Status.alliance.name(), "Alliance member" },
        { Status.wing.name(), "Main/Wing" },
        { Status.bnd.name(), "Bündnispartner" },
        { Status.nap.name(), "Non-Aggression-Pact" },
        { Status.spectral.name(), "Spectral" },
        // Building
        { Building.ironMine.name(), "Pig iron mine" },
        { Building.furnace.name(), "Blast furnace" },
        { Building.kryptoniteMine.name(), "Kryptonite mine" },
        { Building.spiceMine.name(), "Spice mine" },
        { Building.fusionPlant.name(), "Fusion plant" },
        { Building.thermosolarPlant.name(), "Thermosolar plant" },
        { Building.developmentCenter.name(), "Development center" },
        { Building.researchLab.name(), "Research lab" },
        { Building.weaponsFactory.name(), "Weapons factory" },
        { Building.fleetBase.name(), "Fleet base" },
        { Building.ironStorage.name(), "Pig iron warehouse" },
        { Building.metalStorage.name(), "Metal warehouse" },
        { Building.kryptoniteStorage.name(), "Kryptonite warehouse" },
        { Building.spiceStorage.name(), "Spice warehouse" },
        { Building.particleCannon.name(), "Particle cannon" },
        { Building.particleShield.name(), "Particle shield" },
        { Building.msa.name(), "Microsystem accelerator" },
        { Building.teleporter.name(), "Teleporter" },
        { Building.scanner.name(), "Galaxy scanner" },
        // defense
        { Defense.mortar.name(), "Mortar" },
        { Defense.turboFlak.name(), "Turboflak" },
        { Defense.gravitonCannon.name(), "Light graviton cannon" },
        { Defense.heavyGravitonCannon.name(), "Heavy graviton cannon" },
        { Defense.ionGun.name(), "Ion cannon" },
        { Defense.positronLighter.name(), "Positron lighter" },
        { Defense.intervalCannon.name(), "Interval cannon" },
        { Defense.laserBattery.name(), "Laser cannon battery" },
        { Defense.solarGun.name(), "Solar cannon" },
        { Defense.smallShieldDome.name(), "Small shield dome" },
        { Defense.largeShieldDome.name(), "Large shield dome" },
        // Research
        { Research.mining.name(), "Mining technology" },
        { Research.energytech.name(), "Energy technology" },
        { Research.drive.name(), "Engine research" },
        { Research.rocket.name(), "Rocket engines" },
        { Research.diffusion.name(), "Diffusion engines" },
        { Research.warp.name(), "Warp engine" },
        { Research.espionage.name(), "Espionage technology" },
        { Research.weapons.name(), "Weapons technology" },
        { Research.shields.name(), "Shield technology" },
        { Research.structure.name(), "Defense systems" },
        { Research.target.name(), "Targeting systems" },
        { Research.particle.name(), "Particle analyzer" },
        { Research.graviton.name(), "Graviton technology" },
        { Research.teleportation.name(), "Teleportation" },
        { Research.blackhole.name(), "Black hole research" },
        // Resource
        { Resource.iron.name(), "Pig iron" },
        { Resource.metal.name(), "Metal" },
        { Resource.kryptonite.name(), "Kryptonite" },
        { Resource.spice.name(), "Spice" },
        { Resource.energy.name(), "Energy" },
        // ship
        { Ship.none.name(), "" },
        { Ship.smallTransport.name(), "Small transport" },
        { Ship.largeTransport.name(), "Large transport" },
        { Ship.transmitter.name(), "Transmitter" },
        { Ship.smallFighter.name(), "Small fighter" },
        { Ship.manOWar.name(), "Warship" },
        { Ship.starCruiser.name(), "Starcruiser" },
        { Ship.phoenix.name(), "Phoenix" },
        { Ship.colonyShip.name(), "Colony ship" },
        { Ship.solarCell.name(), "Solar cell" },
        { Ship.probe.name(), "Spy probe" },
        { Ship.recycler.name(), "Recycler" },
        { Ship.battleship.name(), "Battleship" },
        { Ship.stealthBomber.name(), "Stealth bomber" },
        { Ship.destroyer.name(), "Destroyer" },
        { Ship.imperialStarbase.name(), "Imperial starbase" },
        // Flavor
        { Flavor.nexus.name(), "Nexus" },
        { Flavor.retro.name(), "Retro" },
        { Flavor.sirius.name(), "Sirius" },
        { Flavor.genesis.name(), "GeNeSIS 2527" },
        { Flavor.solaris.name(), "Dark Gate" },
        { Flavor.speed.name(), "Speed" },
        { Flavor.infinity.name(), "Infinity" },
        // search options
        { SearchOption.attacker.name(), "attackers" },
        { SearchOption.defender.name(), "defenders" },
        { SearchOption.players.name(), "players" },
        { SearchOption.alliances.name(), "alliances" },
        { SearchOption.planets.name(), "planets" },
        { SearchOption.points.name(), "points" },
        { SearchOption.systems.name(), "systems" },
        { SearchOption.time.name(), "time" },
        { SearchOption.attackstatus.name(), "attacked" },
        { SearchOption.level.name(), "level" },
        { "Search.search", "Find by" },
        { "Search.searchCommand", "Search" },
        // MainFrame
        { "MainFrame.menu.file", "File" },
        { "MainFrame.menu.file.mnemonic", "F" },
        { "MainFrame.menu.file.importDb", "Import DB..." },
        { "MainFrame.menu.file.importDb.mnemonic", "I" },
        { "MainFrame.menu.file.exportDb", "Export DB..." },
        { "MainFrame.menu.file.exportDb.mnemonic", "x" },
        { "MainFrame.menu.file.exit", "Exit" },
        { "MainFrame.menu.file.exit.mnemonic", "E" },
        { "MainFrame.menu.skins", "Skins" },
        { "MainFrame.menu.skins.mnemonic", "S" },
        { "MainFrame.menu.skins.restart", "Restart required" },
        { "MainFrame.menu.skins.restart.text", "This change requires a program restart. Proceed?" },
        { "MainFrame.menu.tools", "Tools" },
        { "MainFrame.menu.tools.mnemonic", "T" },
        { "MainFrame.menu.tools.galaxy", "Galaxy view" },
        { "MainFrame.menu.tools.galaxy.mnemonic", "G" },
        { "MainFrame.menu.tools.datatransfer", "Data Transfer" },
        { "MainFrame.menu.tools..datatransfer.mnemonic", "a" },
        { "MainFrame.menu.tools.datatransfer.grabClipboard", "Hijack Clipboard" },
        { "MainFrame.menu.tools.datatransfer.grabClipboard.mnemonic", "C" },
        { "MainFrame.menu.tools.datatransfer.http", "Web Server" },
        { "MainFrame.menu.tools.datatransfer.http.mnemonic", "W" },
        { "MainFrame.menu.tools.import", "Import..." },
        { "MainFrame.menu.tools.import.mnemonic", "I" },
        { "MainFrame.menu.tools.export", "Export" },
        { "MainFrame.menu.tools.export.mnemonic", "E" },
        { "MainFrame.menu.tools.export.battle", "Battle Reports..." },
        { "MainFrame.menu.tools.export.battle.mnemonic", "B" },
        { "MainFrame.menu.tools.export.blackhole", "Black Holes..." },
        { "MainFrame.menu.tools.export.blackhole.mnemonic", "H" },
        { "MainFrame.menu.tools.export.planet", "Planets..." },
        { "MainFrame.menu.tools.export.planet.mnemonic", "P" },
        { "MainFrame.menu.tools.export.spy", "Spy Reports..." },
        { "MainFrame.menu.tools.export.spy.mnemonic", "S" },
        { "MainFrame.menu.tools.fonts", "Font..." },
        { "MainFrame.menu.tools.fonts.mnemonic", "F" },
        { "MainFrame.menu.help", "Help" },
        { "MainFrame.menu.help.mnemonic", "H" },
        { "MainFrame.menu.help.help", "Help..." },
        { "MainFrame.menu.help.help.mnemonic", "H" },
        { "MainFrame.menu.help.info", "Info..." },
        { "MainFrame.menu.help.info.mnemonic", "I" },
        { "MainFrame.account", "Account" },
        { "MainFrame.accounts", "Accounts..." },
        { "MainFrame.blackholes", "Black Holes" },
        { "MainFrame.players", "Players" },
        { "MainFrame.planets", "Planets" },
        { "MainFrame.battleReports", "Battle reports" },
        { "MainFrame.spyReports", "Spy reports" },
        //help
        { "Help.title", "{0} Help" },
        { "Help.url", "/help_en.html" },
        // points
        { "Points", "Points" },
        { "Points.buildings", "Buildings: " },
        { "Points.research", "Research: " },
        { "Points.fleet", "Fleet: " },
        { "Points.total", "Total: " },
        // account
        { "Account.title", "Accounts" },
        { "Account.name", "Account name" },
        { "Account.isdefault", "default" },
        { "Account.language", "Language" },
        { "Account.version", "Version" },
        { "Account.outpost", "Outpost" },
        { "Account.create", "Create account" },
        { "Account.remove.selected", "Delete selected" },
        { "Account.already.exists", "Account already exists" },
        { "Account.unsaved.data", "You have unsaved data. Really close?" },
        { "Account.language.nomatch", "Account language or version does not match!" },
        { "Account.name.nomatch", "Account name does not match. Continue?" },
        { "Version.nomatch", "The version to be imported ({0}) might be too old. \nPossibly it doesn't contain all needed data. \nContinue?" },
        // galaxy view
        { "GalaxyView.sun", " Sun " },
        // import
        { "ImportFrame.spyMarker", "Spy\\s+report\\s+from" },
        { "ImportFrame.battleMarker", "The\\s*following\\s*fleets\\s*fought" },
        { "ImportFrame.galaxyMarker", "Sun" },
        { "ImportFrame.galaxyMarker.owner", "Owner" },
        { "ImportFrame.galaxyMarker.points", "Points" },
        { "ImportFrame.galaxyMarker.position", "Position" },
        { "ImportFrame.galaxyMarker.alliance", "Alliance" },
        { "ImportFrame.galaxyMarker.status", "Status" },
        { "ImportFrame.galaxyMarker.end", "Info\\sClose" },
        { "Import.retry", "Import failed. Please try again." },
        // battle report
        { "BattleReport.battleReport", "Battle Report" },
        { "BattleReport.attacker", "Attacker" },
        { "BattleReport.defender", "Defender" },
        { "BattleReport.round", "ROUND" },
        { "BattleReport.firstStrike", "STEALTH BOMBER FIRST STRIKE" },
        { "BattleReport.destroyed", "DESTROYED" },
        { "BattleReport.damage", "Weapons" },
        { "BattleReport.shield", "Shield" },
        { "BattleReport.structure", "Defense" },
        { "BattleReport.shields", "Schield" },
        { "BattleReport.firepower", "Firepower" },
        { "BattleReport.type", "Type" },
        { "BattleReport.number", "Number" },
        { "BattleReport.numberBefore", "Anzahl Vorher" },
        { "BattleReport.numberAfter", "Anzahl Nachher" },
        { "BattleReport.bomber", "Stealth bomber" },
        { "BattleReport.bomberResult", "The stealth bombers destroyed {0} defense installations in the first strike attack." },
        { "BattleReport.attacking", "attacking" },
        { "BattleReport.defending", "defending" },
        { "BattleReport.attackMessage", "The {0} fleet fires with a firepower of {1} damage points." },
        { "BattleReport.shieldMessage", "The shields of the {0} fleet absorb {1} damage points." },
        { "BattleReport._attacker", "attacker" },
        { "BattleReport._defender", "defender" },
        { "BattleReport.winMessage", "The {0} won the battle!" },
        { "BattleReport.drawMessage", "The battle ended in a draw: The attacking fleet withdraws to its home planet!" },
        { "BattleReport.plunder", "He won {0} pieces of pig iron, {1} pieces of metal, {2} kryptonite crystals, {3} units of spice" },
        { "BattleReport.loss", "The {0} lost a total of {1} units." },
        { "BattleReport.rubble", "There are now {0} metal and {1} kryptonite at these space coordinates." },
        { "BattleReport.astrochance", "The chance of an asteroid forming is {0}%" },
        { "BattleReport.asteroid", "An asteroid formed out of the rubble!" },
        // spy report
        { "SpyReport.spyreport", "Spy report" },
        { "SpyReport.header", "Spy report from" },
        { "SpyReport.from", "from" },
        { "SpyReport.buildings", "Building" },
        { "SpyReport.defense", "Defense" },
        { "SpyReport.ships", "Fleet" },
        { "SpyReport.research", "Research" },
        { "SpyReport.counterespionage", "Counterespionage chances:" },
        { "Report.time", "Time" },
        { "Report.priority", "" },
        { "Report.attacker", "Attacker" },
        { "Report.defender", "Defender" },
        // galaxy view
        { "GalaxyView.uninhabited", "Uninhabited planet" },
        { "GalaxyView.owner", "Owner" },
        { "GalaxyView.specialization", "Specialization" },
        { "GalaxyView.points", "Points" },
        { "GalaxyView.spiceValue", "Spice" },
        { "GalaxyView.position", "Position" },
        { "GalaxyView.temperature", "Temperature" },
        { "GalaxyView.alliance", "Alliance" },
        { "GalaxyView.status", "Status" },
        { "GalaxyView.debris", "Space rubble" },
        { "GalaxyView.lastUpdated", "Last updated" },
        // planet view
        { "PlanetView.coords", "Planet" },
        { "Popup.show", "Show" },
        { "Popup.showPlayer", "Show player" },
        { "Popup.showAlliance", "Show alliance" },
        { "Popup.showSystem", "Show system" },
        { "Popup.goto", "Goto" },
        { "Popup.spyReports", "Show spy reports" },
        { "Popup.battleReports", "Show battle reports" },
        // DB info
        { "MainFrame.menu.tools.dbInfo", "DB Info..." },
        { "MainFrame.menu.tools.dbInfo.mnemonic", "D" },
        { "DbInfo.config", "Properties file" },
        { "DbInfo.dbpath", "Database" },
        { "DbInfo.contents", "DB account contents" },
        { "DbInfo.alliances", "Alliances" },
        { "DbInfo.blackHoles", "Black holes" },
        { "DbInfo.players", "Player" },
        { "DbInfo.planets", "Planets" },
        { "DbInfo.spyReports", "Spy reports" },
        { "DbInfo.battleReports", "Battle reports" },
        // notes
        { "NoteBox.title", "Notes" },
        // black holes
        { "BlackHole.attacked", "Attack status" },
        { "BlackHole.coords", "Coordinates" },
        { "BlackHole.level", "Level" },
        { "BlackHole.power", "Attack power" },
        { "BlackHole.ships", "Required fleet" },
        { "BlackHole.rewards", "Loot" },
        { "BlackHole.rewards.emblems", "Emblems" },
        { "BlackHole.rewards.stars", "Stars" },
        { AttackStatus.all.name(), "all" },
        { AttackStatus.attacked.name(), "attacked" },
        { AttackStatus.notattacked.name(), "not attacked" },
        { BlackHoleLevel.all.name(), "all" },
        { BlackHoleLevel.white.name(), "white" },
        { BlackHoleLevel.green.name(), "green" },
        { BlackHoleLevel.blue.name(), "blue" },
        { BlackHoleLevel.red.name(), "red" },
    };

    @Override
    protected Object[][] getContents()
    {
        return contents;
    }

}
