/****************************************
 *  COPYRIGHT (C) 2008-2024
 *  Holger Graf
 ****************************************/
package siarchive.i18n;

import java.util.ListResourceBundle;

import siarchive.components.AttackStatus;
import siarchive.components.BlackHoleLevel;
import siarchive.components.Building;
import siarchive.components.Defense;
import siarchive.components.Flavor;
import siarchive.components.Research;
import siarchive.components.Resource;
import siarchive.components.SearchOption;
import siarchive.components.Ship;
import siarchive.components.Status;

/**
 * @author graf
 *
 */
public class Messages_de extends ListResourceBundle
{
    // I'm less than impressed with the .properties handling (especially this native2ascii thingie),
    // lets try this
    private static final Object[][] contents =
    {
        // controls
        { "OK", "OK" },
        { "Close", "Schließen" },
        { "New", "Neu" },
        { "Load", "Laden..." },
        { "Save", "Speichern..." },
        { "Import", "Einlesen..." },
        { "load", "{0} laden" },
        { "save", "{0} speichern" },
        { "file.exists", "Die Datei existiert bereits. Überschreiben?" },
        { "confirm.overwrite", "Überschreiben bestätigen" },
        { "Compute", "Berechnen" },
        { "Error", "Fehler" },
        { "Warning", "Warnung" },
        { "Really.quit", "Wirklich beenden?" },
        { "Planet", "Planet" },
        { "Asteroid", "Asteroid" },
        { "Building", "Gebäude" },
        { "Temperature", "Temperatur" },
        { "Level", "Stufe" },
        { "max.Level", "max. Level" },
        { "day.symbol", "T" },
        { "add", "Hinzufügen" },
        { "delete", "Auswahl löschen" },
        { "deleteAll", "Alles löschen" },
        { "export", "Auswahl exportieren..." },
        { "exportAll", "Alles exportieren..." },
        // enums
        // Language
        { Language.german.name(), "deutsch" },
        { Language.english.name(), "englisch" },
        { Language.russian.name(), "russisch" },
        // Status
        { Status.none.name(), "" },
        { Status.noob.name(), "Im Noobschutz" },
        { Status.vacation.name(), "Im Urlaubsmodus" },
        { Status.inactive.name(), "Inaktiv" },
        { Status.enemy.name(), "Feindlich" },
        { Status.strong.name(), "Stark" },
        { Status.operator.name(), "Game-Operator" },
        { Status.locked.name(), "locked" },
        { Status.alliance.name(), "Allianzmitglied" },
        { Status.wing.name(), "Main/Wing" },
        { Status.bnd.name(), "Bündnispartner" },
        { Status.nap.name(), "Nicht-Angriffs-Pakt" },
        { Status.spectral.name(), "Spektral" },
        // Building
        { Building.ironMine.name(), "Roheisenmine" },
        { Building.furnace.name(), "Hochofen" },
        { Building.kryptoniteMine.name(), "Kryptonitmine" },
        { Building.spiceMine.name(), "Spicemine" },
        { Building.fusionPlant.name(), "Fusionskraftwerk" },
        { Building.thermosolarPlant.name(), "Thermosolarfabrik" },
        { Building.developmentCenter.name(), "Entwicklungszentrum" },
        { Building.researchLab.name(), "Forschungslabor" },
        { Building.weaponsFactory.name(), "Waffenfabrik" },
        { Building.fleetBase.name(), "Flottenstützpunkt" },
        { Building.ironStorage.name(), "Roheisenlager" },
        { Building.metalStorage.name(), "Metalllager" },
        { Building.kryptoniteStorage.name(), "Kryptonitlager" },
        { Building.spiceStorage.name(), "Spicelager" },
        { Building.particleCannon.name(), "Partikelkanone" },
        { Building.particleShield.name(), "Partikelschild" },
        { Building.msa.name(), "Microsystembeschleuniger" },
        { Building.teleporter.name(), "Teleporter" },
        { Building.scanner.name(), "GalaxyScanner" },
        // defense
        { Defense.mortar.name(), "Mörser" },
        { Defense.turboFlak.name(), "Turboflak" },
        { Defense.gravitonCannon.name(), "Leichte Gravitonkanone" },
        { Defense.heavyGravitonCannon.name(), "Schwere Gravitonkanone" },
        { Defense.ionGun.name(), "Ionengeschütz" },
        { Defense.positronLighter.name(), "Positron Lighter" },
        { Defense.intervalCannon.name(), "Intervallkanone" },
        { Defense.laserBattery.name(), "Laserkanonenbatterie" },
        { Defense.solarGun.name(), "Solargeschütz" },
        { Defense.smallShieldDome.name(), "Kleine Schildkuppel" },
        { Defense.largeShieldDome.name(), "Große Schildkuppel" },
        // Research
        { Research.mining.name(), "Minentechnik" },
        { Research.energytech.name(), "Energietechnik" },
        { Research.drive.name(), "Antriebsforschung" },
        { Research.rocket.name(), "Raketentriebwerk" },
        { Research.diffusion.name(), "Diffusionstriebwerk" },
        { Research.warp.name(), "Warpantrieb" },
        { Research.espionage.name(), "Spionagetechnik" },
        { Research.weapons.name(), "Waffentechnik" },
        { Research.shields.name(), "Schildtechnik" },
        { Research.structure.name(), "Abwehrsysteme" },
        { Research.target.name(), "Zielsysteme" },
        { Research.particle.name(), "Partikel-Analyser" },
        { Research.graviton.name(), "Gravitontechnik" },
        { Research.teleportation.name(), "Teleportation" },
        { Research.blackhole.name(), "Schwarzes Loch Forschung" },
        // Resource
        { Resource.iron.name(), "Roheisen" },
        { Resource.metal.name(), "Metall" },
        { Resource.kryptonite.name(), "Kryptonit" },
        { Resource.spice.name(), "Spice" },
        { Resource.energy.name(), "Energie" },
        // ship
        { Ship.none.name(), "" },
        { Ship.smallTransport.name(), "Kleiner Transporter" },
        { Ship.largeTransport.name(), "Großer Transporter" },
        { Ship.transmitter.name(), "Transmitter" },
        { Ship.smallFighter.name(), "Kleiner Jäger" },
        { Ship.manOWar.name(), "Kriegsschiff" },
        { Ship.starCruiser.name(), "Sternenkreuzer" },
        { Ship.phoenix.name(), "Phoenix" },
        { Ship.colonyShip.name(), "Kolonieschiff" },
        { Ship.solarCell.name(), "Solarzelle" },
        { Ship.probe.name(), "Spionagesonde" },
        { Ship.recycler.name(), "Recycler" },
        { Ship.battleship.name(), "Schlachtschiff" },
        { Ship.stealthBomber.name(), "Tarnkappenbomber" },
        { Ship.destroyer.name(), "Zerstörer" },
        { Ship.imperialStarbase.name(), "Imperiale Sternenbasis" },
        // Flavor
        { Flavor.nexus.name(), "Nexus" },
        { Flavor.retro.name(), "Retro" },
        { Flavor.sirius.name(), "Sirius" },
        { Flavor.genesis.name(), "GeNeSIS 2527" },
        { Flavor.solaris.name(), "Dark Gate" },
        { Flavor.speed.name(), "Speed" },
        { Flavor.infinity.name(), "Infinity" },
        // search options
        { SearchOption.attacker.name(), "Angreifern" },
        { SearchOption.defender.name(), "Verteidigern" },
        { SearchOption.players.name(), "Spielern" },
        { SearchOption.alliances.name(), "Allianzen" },
        { SearchOption.planets.name(), "Planeten" },
        { SearchOption.points.name(), "Punkten" },
        { SearchOption.systems.name(), "Systemen" },
        { SearchOption.time.name(), "Zeit" },
        { SearchOption.attackstatus.name(), "Angriffsstatus" },
        { SearchOption.level.name(), "Level" },
        { "Search.search", "Suche nach" },
        { "Search.searchCommand", "Suchen" },
        // MainFrame
        { "MainFrame.menu.file", "Datei" },
        { "MainFrame.menu.file.mnemonic", "D" },
        { "MainFrame.menu.file.importDb", "DB Importieren..." },
        { "MainFrame.menu.file.importDb.mnemonic", "I" },
        { "MainFrame.menu.file.exportDb", "DB Exportieren..." },
        { "MainFrame.menu.file.exportDb.mnemonic", "x" },
        { "MainFrame.menu.file.exit", "Beenden" },
        { "MainFrame.menu.file.exit.mnemonic", "e" },
        { "MainFrame.menu.skins", "Skins" },
        { "MainFrame.menu.skins.mnemonic", "S" },
        { "MainFrame.menu.skins.restart", "Neustart erforderlich" },
        { "MainFrame.menu.skins.restart.text", "Diese Änderung erfordert einen Neustart des Programms. Fortfahren?" },
        { "MainFrame.menu.tools", "Tools" },
        { "MainFrame.menu.tools.mnemonic", "T" },
        { "MainFrame.menu.tools.galaxy", "Galaxieansicht" },
        { "MainFrame.menu.tools.galaxy.mnemonic", "G" },
        { "MainFrame.menu.tools.datatransfer", "Datenübernahme" },
        { "MainFrame.menu.tools..datatransfer.mnemonic", "a" },
        { "MainFrame.menu.tools.datatransfer.grabClipboard", "Clipboard übernehmen" },
        { "MainFrame.menu.tools.datatransfer.grabClipboard.mnemonic", "C" },
        { "MainFrame.menu.tools.datatransfer.http", "Webserver" },
        { "MainFrame.menu.tools.datatransfer.http.mnemonic", "W" },
        { "MainFrame.menu.tools.import", "Importieren..." },
        { "MainFrame.menu.tools.import.mnemonic", "I" },
        { "MainFrame.menu.tools.export", "Exportieren" },
        { "MainFrame.menu.tools.export.mnemonic", "E" },
        { "MainFrame.menu.tools.export.battle", "Kampfberichte..." },
        { "MainFrame.menu.tools.export.battle.mnemonic", "K" },
        { "MainFrame.menu.tools.export.blackhole", "Schwarze Löcher..." },
        { "MainFrame.menu.tools.export.blackhole.mnemonic", "L" },
        { "MainFrame.menu.tools.export.planet", "Planeten..." },
        { "MainFrame.menu.tools.export.planet.mnemonic", "P" },
        { "MainFrame.menu.tools.export.spy", "Spionageberichte..." },
        { "MainFrame.menu.tools.export.spy.mnemonic", "S" },
        { "MainFrame.menu.tools.fonts", "Schriftart..." },
        { "MainFrame.menu.tools.fonts.mnemonic", "S" },
        { "MainFrame.menu.help", "Hilfe" },
        { "MainFrame.menu.help.mnemonic", "H" },
        { "MainFrame.menu.help.help", "Hilfe..." },
        { "MainFrame.menu.help.help.mnemonic", "H" },
        { "MainFrame.menu.help.info", "Info..." },
        { "MainFrame.menu.help.info.mnemonic", "I" },
        { "MainFrame.account", "Account" },
        { "MainFrame.accounts", "Accounts..." },
        { "MainFrame.blackholes", "Schwarze Löcher" },
        { "MainFrame.players", "Spieler" },
        { "MainFrame.planets", "Planeten" },
        { "MainFrame.battleReports", "Kampfberichte" },
        { "MainFrame.spyReports", "Spionageberichte" },
        //help
        { "Help.title", "{0} Hilfe" },
        { "Help.url", "/help.html" },
        // account
        { "Account.title", "Accounts" },
        { "Account.name", "Account Name" },
        { "Account.isdefault", "default" },
        { "Account.language", "Sprache" },
        { "Account.version", "Version" },
        { "Account.outpost", "Außenposten" },
        { "Account.create", "Account anlegen" },
        { "Account.remove.selected", "Auswahl löschen" },
        { "Account.already.exists", "Account existiert bereits" },
        { "Account.unsaved.data", "Das Eingabefeld enthält noch Daten. Wirklich beenden?" },
        { "Account.language.nomatch", "Die Account Sprache oder Version stimmt nicht überein!" },
        { "Account.name.nomatch", "Der Account Name stimmt nicht überein. Weitermachen?" },
        { "Version.nomatch", "Die zu importierende Verson ({0}) ist veraltet. \nSie enthält möglicherweise unvollständige Information. \nWeitermachen?" },
        // galaxy view
        { "GalaxyView.sun", "Sonne" },
        // import
        { "ImportFrame.spyMarker", "Spionagebericht\\s*von" },
        { "ImportFrame.battleMarker", "Folgende\\s*Flotten\\s*st\\S+en\\s*sich" },
        { "ImportFrame.galaxyMarker", "Sonne" },
        { "ImportFrame.galaxyMarker.owner", "Besitzer" },
        { "ImportFrame.galaxyMarker.points", "Punkte" },
        { "ImportFrame.galaxyMarker.position", "Position" },
        { "ImportFrame.galaxyMarker.alliance", "Allianz" },
        { "ImportFrame.galaxyMarker.status", "Status" },
        { "ImportFrame.galaxyMarker.end", "Info\\s*Schließen" },
        { "Import.retry", "Einlesen fehlerhaft. Bitte wiederholen." },
        // battle report
        { "BattleReport.battleReport", "Kampfbericht" },
        { "BattleReport.attacker", "Angreifer" },
        { "BattleReport.defender", "Verteidiger" },
        { "BattleReport.round", "RUNDE" },
        { "BattleReport.firstStrike", "TARNKAPPENBOMBER ERSTSCHLAG" },
        { "BattleReport.destroyed", "VERNICHTET" },
        { "BattleReport.damage", "Waffen" },
        { "BattleReport.shield", "Schild" },
        { "BattleReport.structure", "Abwehr" },
        { "BattleReport.shields", "Schilde" },
        { "BattleReport.firepower", "Schuss" },
        { "BattleReport.type", "Typ" },
        { "BattleReport.number", "Anzahl" },
        { "BattleReport.numberBefore", "Anzahl Vorher" },
        { "BattleReport.numberAfter", "Anzahl Nachher" },
        { "BattleReport.bomber", "Tarnkappenbomber" },
        { "BattleReport.bomberResult", "Die Tarnkappenbomber haben in einem Erstschlag {0} Verteidigungsanlagen zerstört." },
        { "BattleReport.attacking", "angreifende" },
        { "BattleReport.defending", "verteidigende" },
        { "BattleReport.attackMessage", "Die {0} Flotte schiesst mit einer Schusskraft von {1} Schadenspunkten." },
        { "BattleReport.shieldMessage", "Die Schilde der {0}n Flotte absorbieren davon {1} Schadenspunkte." },
        { "BattleReport._attacker", "Angreifer" },
        { "BattleReport._defender", "Verteidiger" },
        { "BattleReport.winMessage", "Der {0} hat die Schlacht gewonnen!" },
        { "BattleReport.drawMessage", "Die Schlacht endet unentschieden, die angreifende Flotte zieht sich auf ihren Heimatplaneten zurück!" },
        { "BattleReport.plunder", "Er erbeutet {0} Roheisen, {1} Metall, {2} Kryptonit, {3} Spice" },
        { "BattleReport.loss", "Der {0} hat insgesamt {1} Einheiten verloren." },
        { "BattleReport.rubble", "Auf diesen Raumkoordinaten liegen nun {0} Metall und {1} Kryptonit mehr." },
        { "BattleReport.astrochance", "Die Chance einer Asteroidenstehung beträgt {0}%" },
        { "BattleReport.asteroid", "Aus den Trümmerteilen hat sich ein Asteroid gebildet!" },
        // spy report
        { "SpyReport.spyreport", "Spionagebericht" },
        { "SpyReport.header", "Spionagebericht von" },
        { "SpyReport.from", "vom" },
        { "SpyReport.buildings", "Gebäude" },
        { "SpyReport.defense", "Verteidigung" },
        { "SpyReport.ships", "Flotte" },
        { "SpyReport.research", "Forschungen" },
        { "SpyReport.counterespionage", "Chance auf Spionageabwehr:" },
        { "Report.time", "Zeit" },
        { "Report.attacker", "Angreifer" },
        { "Report.defender", "Verteidiger" },
        { "Report.priority", "" },
        // galaxy view
        { "GalaxyView.uninhabited", "Unbewohnter Planet" },
        { "GalaxyView.owner", "Besitzer" },
        { "GalaxyView.specialization", "Spezialisierung" },
        { "GalaxyView.points", "Punkte" },
        { "GalaxyView.spiceValue", "Spice" },
        { "GalaxyView.position", "Position" },
        { "GalaxyView.temperature", "Temperatur" },
        { "GalaxyView.alliance", "Allianz" },
        { "GalaxyView.status", "Status" },
        { "GalaxyView.debris", "Trümmerfeld" },
        { "GalaxyView.lastUpdated", "Eingelesen am" },
        // planet view
        { "PlanetView.coords", "Planet" },
        { "Popup.show", "Anzeigen" },
        { "Popup.showPlayer", "Spieler anzeigen" },
        { "Popup.showAlliance", "Alliance anzeigen" },
        { "Popup.showSystem", "System anzeigen" },
        { "Popup.goto", "Gehe zu" },
        { "Popup.spyReports", "Spionageberichte anzeigen" },
        { "Popup.battleReports", "Kampfberichte anzeigen" },
        // DB info
        { "MainFrame.menu.tools.dbInfo", "DB Info..." },
        { "MainFrame.menu.tools.dbInfo.mnemonic", "D" },
        { "DbInfo.config", "Properties-Datei" },
        { "DbInfo.dbpath", "Datenbank" },
        { "DbInfo.contents", "DB Account Info" },
        { "DbInfo.alliances", "Allianzen" },
        { "DbInfo.blackHoles", "Schwarze Löcher" },
        { "DbInfo.players", "Spieler" },
        { "DbInfo.planets", "Planeten" },
        { "DbInfo.spyReports", "Spionageberichte" },
        { "DbInfo.battleReports", "Kampfberichte" },
        // notes
        { "NoteBox.title", "Notizen" },
        // black holes
        { "BlackHole.attacked", "Angriffsstatus" },
        { "BlackHole.coords", "Koordinaten" },
        { "BlackHole.level", "Level" },
        { "BlackHole.power", "Kampfkraft" },
        { "BlackHole.ships", "benötigte Flotte" },
        { "BlackHole.ships.number", "Anzahl" },
        { "BlackHole.rewards", "Belohnung" },
        { "BlackHole.rewards.emblems", "Embleme" },
        { "BlackHole.rewards.stars", "Sterne" },
        { AttackStatus.all.name(), "alle" },
        { AttackStatus.attacked.name(), "angegriffen" },
        { AttackStatus.notattacked.name(), "nicht angegriffen" },
        { BlackHoleLevel.all.name(), "alle" },
        { BlackHoleLevel.white.name(), "weiß" },
        { BlackHoleLevel.green.name(), "grün" },
        { BlackHoleLevel.blue.name(), "blau" },
        { BlackHoleLevel.red.name(), "rot" },
    };

    @Override
    protected Object[][] getContents()
    {
        return contents;
    }

}
