/****************************************
 *  COPYRIGHT (C) 2008
 *  Holger Graf
 ****************************************/
package siarchive.i18n;

import java.util.Locale;

public enum Language 
{
    german( Locale.GERMAN ),
    english( Locale.ENGLISH ),               // this is the default and will be set on update
    russian( new Locale( "ru", "RU" ) );
    
    private Locale locale;

    /**
     * @param locale
     */
    private Language( Locale locale )
    {
        this.locale = locale;
    }

    /**
     * @return the locale
     */
    public Locale getLocale()
    {
        return locale;
    }
    
}
