/****************************************
*  COPYRIGHT (C) 2009-2024
*  Holger Graf
 ****************************************/
package siarchive.galaxy;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.jr.ob.JSON;

import siarchive.components.Flavor;
import siarchive.components.PlanetData;
import siarchive.components.Position;
import siarchive.json.galaxy.PlanetVisibility;
import siarchive.json.galaxy.VisibilityMap;

public class SystemData
{
    private static int[][][] planetData = new int[][][]
    {
        {
            { 24, 454, -55 }, { 148, 512, -42 }, { 77, 375, -9 }, { 205, 437, 4 }, { 53, 219, 5 }, { 295, 395, 31 }, { 455, 489, -41 }, { 182, 150, 59 }, { 378, 280, 63 }, { 551, 387, -38 }, { 267, 37, 29 }, { 473, 177, 23 }, { 448, 86, 14 }, { 661, 233, -69 }, { 644, 150, -64 }, { 625, 65, -67 },
        },
        {
            { 56, 486, -61 }, { 151, 515, -35 }, { 315, 523, -2 }, { 107, 339, -7 }, { 252, 418, 35 }, { 627, 532, -64 }, { 338, 372, 74 }, { 496, 464, 5 }, { 221, 123, 16 }, { 419, 255, 85 }, { 586, 356, -1 }, { 320, 24, -10 }, { 523, 161, 16 }, { 596, 168, -13 }, { 521, 27, -32 }, { 635, 235, -22 },
        },
        {
            { 14, 434, -65 }, { 209, 533, -27 }, { 79, 377, -24 }, { 378, 530, -9 }, { 239, 405, 35 }, { 297, 397, 54 }, { 108, 142, -17 }, { 479, 447, 12 }, { 435, 337, 66 }, { 264, 100, 23 }, { 361, 131, 48 }, { 519, 223, 31 }, { 477, 115, 17 }, { 476, 48, -10 }, { 646, 152, -41 }, { 583, 23, -52 },
        },
        {
            { 58, 488, -52 }, { 11, 375, -44 }, { 260, 528, -13 }, { 209, 441, 17 }, { 436, 502, -10 }, { 172, 272, 45 }, { 340, 374, 67 }, { 142, 110, 0 }, { 518, 420, -4 }, { 472, 308, 43 }, { 309, 79, 25 }, { 406, 110, 30 }, { 650, 288, -44 }, { 539, 111, -14 }, { 532, 38, -36 }, { 577, 337, -12 },
        },
        {
            { 63, 493, -50 }, { 211, 535, -24 }, { 22, 320, -31 }, { 209, 441, 18 }, { 141, 307, 28 }, { 490, 530, -36 }, { 208, 242, 62 }, { 381, 349, 70 }, { 627, 532, -82 }, { 455, 291, 52 }, { 606, 376, -33 }, { 359, 63, 15 }, { 552, 190, -3 }, { 679, 251, -60 }, { 506, 12, -39 }, { 570, 330, -9 },
        },
        {
            { 16, 446, -72 }, { 219, 543, -25 }, { 162, 460, -12 }, { 38, 270, -46 }, { 456, 522, -1 }, { 274, 374, 58 }, { 438, 472, 25 }, { 245, 213, 45 }, { 420, 322, 92 }, { 225, 61, -18 }, { 490, 260, 57 }, { 637, 341, -16 }, { 411, 49, -5 }, { 600, 172, -11 }, { 706, 212, -53 }, { 577, 17, -54 },
        },
        {
            { 30, 460, -66 }, { 12, 296, -53 }, { 273, 541, -15 }, { 211, 443, 13 }, { 159, 325, 19 }, { 401, 501, 11 }, { 210, 244, 43 }, { 482, 450, 17 }, { 284, 186, 58 }, { 457, 293, 71 }, { 273, 43, -9 }, { 623, 327, -14 }, { 566, 204, 8 }, { 467, 39, -15 }, { 650, 156, -40 }, { 631, 71, -54 },
        },
        {
            { 62, 492, -61 }, { 157, 521, -37 }, { 50, 348, -35 }, { 225, 457, 9 }, { 358, 524, -5 }, { 627, 532, -68 }, { 344, 378, 68 }, { 247, 215, 60 }, { 521, 423, 7 }, { 325, 161, 62 }, { 492, 262, 50 }, { 326, 30, -3 }, { 454, 92, 15 }, { 592, 164, -12 }, { 727, 233, -69 }, { 601, 41, -51 },
        },
        {
            { 10, 440, -58 }, { 215, 539, -51 }, { 85, 383, -11 }, { 172, 404, 7 }, { 474, 540, -76 }, { 303, 403, 19 }, { 114, 148, 34 }, { 385, 353, 27 }, { 386, 288, 51 }, { 555, 391, -48 }, { 367, 137, 64 }, { 525, 229, -5 }, { 383, 21, 15 }, { 583, 155, -35 }, { 716, 222, -100 }, { 589, 29, -59 },
        },
        {
            { 25, 455, -61 }, { 17, 381, -49 }, { 266, 534, -17 }, { 215, 447, 12 }, { 98, 264, 2 }, { 421, 521, -14 }, { 346, 380, 64 }, { 148, 116, 0 }, { 524, 426, -3 }, { 327, 163, 67 }, { 585, 355, -13 }, { 512, 216, 28 }, { 456, 94, 14 }, { 545, 117, -9 }, { 710, 216, -69 }, { 638, 78, -59 },
        },
        {
            { 34, 464, -67 }, { 145, 509, -32 }, { 28, 326, -54 }, { 215, 447, 15 }, { 147, 313, 6 }, { 126, 226, -11 }, { 365, 399, 75 }, { 487, 455, 29 }, { 627, 532, -48 }, { 461, 297, 77 }, { 369, 139, 34 }, { 609, 313, 3 }, { 458, 96, 5 }, { 585, 157, -10 }, { 712, 218, -55 }, { 635, 75, -55 },
        },
        {
            { 22, 452, -61 }, { 161, 525, -29 }, { 67, 365, -24 }, { 44, 276, -31 }, { 262, 428, 40 }, { 280, 380, 65 }, { 159, 193, 14 }, { 406, 374, 69 }, { 526, 428, 7 }, { 231, 67, -6 }, { 496, 266, 44 }, { 414, 118, 27 }, { 629, 267, -22 }, { 506, 78, -13 }, { 612, 118, -39 }, { 723, 323, -69 },
        },
        {
            { 36, 466, -66 }, { 138, 502, -69 }, { 89, 387, -19 }, { 392, 544, -112 }, { 65, 231, 39 }, { 307, 407, -32 }, { 216, 250, 57 }, { 194, 162, 102 }, { 445, 347, -49 }, { 363, 199, 26 }, { 279, 49, 60 }, { 529, 233, -58 }, { 460, 98, -17 }, { 604, 316, -109 }, { 656, 162, -114 }, { 637, 77, -106 },
        },
        {
            { 68, 498, -53 }, { 163, 527, -34 }, { 56, 354, -22 }, { 219, 451, 13 }, { 120, 286, 17 }, { 50, 90, -43 }, { 350, 384, 60 }, { 253, 221, 77 }, { 233, 135, 40 }, { 582, 418, -29 }, { 498, 268, 34 }, { 332, 36, 5 }, { 460, 98, 12 }, { 608, 180, -28 }, { 605, 261, -20 }, { 607, 47, -58 },
        },
        {
            { 104, 534, -60 }, { 121, 485, -34 }, { 91, 389, -7 }, { 378, 530, -42 }, { 251, 417, 21 }, { 150, 250, 53 }, { 120, 154, 33 }, { 391, 359, 32 }, { 292, 194, 105 }, { 276, 112, 65 }, { 516, 286, -2 }, { 631, 335, -64 }, { 389, 27, 9 }, { 589, 161, -37 }, { 558, 64, -39 }, { 601, 201, -40 },
        },
        {
            { 70, 500, -57 }, { 188, 532, -30 }, { 327, 512, 12 }, { 121, 353, 1 }, { 104, 270, -2 }, { 384, 484, 15 }, { 284, 318, 83 }, { 154, 122, -4 }, { 430, 332, 70 }, { 333, 169, 65 }, { 221, 101, 12 }, { 547, 251, 19 }, { 462, 100, 14 }, { 551, 123, -8 }, { 716, 222, -67 }, { 609, 49, -54 },
        },
        {
            { 40, 470, -58 }, { 223, 547, -24 }, { 365, 543, -9 }, { 221, 453, 16 }, { 153, 319, 22 }, { 132, 232, 10 }, { 320, 354, 84 }, { 220, 188, 39 }, { 93, 85, -42 }, { 567, 403, -4 }, { 475, 245, 52 }, { 371, 75, 13 }, { 676, 314, -45 }, { 591, 163, -17 }, { 518, 24, -37 }, { 581, 181, -9 },
        },
        {
            { 28, 458, -67 }, { 167, 531, -40 }, { 374, 522, -6 }, { 437, 549, -26 }, { 268, 434, 28 }, { 186, 286, 37 }, { 65, 99, -47 }, { 357, 325, 92 }, { 259, 161, 48 }, { 237, 73, 6 }, { 502, 272, 45 }, { 420, 124, 39 }, { 423, 61, 10 }, { 602, 174, -14 }, { 718, 224, -64 }, { 589, 29, -49 },
        },
        {
            { 42, 472, -62 }, { 144, 508, -33 }, { 95, 393, -20 }, { 223, 455, 13 }, { 401, 517, 2 }, { 313, 413, 53 }, { 222, 256, 52 }, { 200, 168, 23 }, { 496, 398, 30 }, { 401, 237, 86 }, { 285, 55, -1 }, { 635, 339, -23 }, { 466, 104, 13 }, { 479, 51, -13 }, { 626, 132, -36 }, { 643, 83, -56 },
        },
        {
            { 35, 465, -65 }, { 169, 533, -31 }, { 62, 360, -36 }, { 225, 457, 16 }, { 370, 536, 5 }, { 560, 540, -31 }, { 356, 390, 78 }, { 259, 227, 52 }, { 239, 141, 15 }, { 437, 273, 82 }, { 345, 115, 24 }, { 338, 42, -13 }, { 666, 304, -28 }, { 514, 86, -12 }, { 639, 145, -37 }, { 688, 288, -40 },
        },
        {
            { 22, 452, -75 }, { 155, 519, -36 }, { 97, 395, -30 }, { 384, 536, 5 }, { 257, 423, 34 }, { 515, 495, 5 }, { 411, 445, 49 }, { 397, 365, 90 }, { 298, 200, 51 }, { 282, 118, 13 }, { 479, 249, 64 }, { 393, 97, 15 }, { 495, 133, 17 }, { 695, 267, -37 }, { 564, 70, -29 }, { 701, 141, -59 },
        },
        {
            { 76, 506, -57 }, { 29, 393, -55 }, { 177, 475, -7 }, { 327, 519, 12 }, { 110, 276, -10 }, { 290, 390, 63 }, { 458, 492, 17 }, { 557, 525, -24 }, { 436, 338, 83 }, { 339, 175, 52 }, { 227, 107, -2 }, { 524, 228, 33 }, { 443, 81, 1 }, { 557, 129, -10 }, { 722, 228, -61 }, { 615, 55, -57 },
        },
        {
            { 46, 476, -59 }, { 229, 533, -18 }, { 40, 338, -36 }, { 202, 434, 15 }, { 159, 325, 23 }, { 138, 238, 13 }, { 326, 360, 80 }, { 499, 467, 1 }, { 590, 325, 3 }, { 673, 509, -78 }, { 381, 151, 52 }, { 377, 81, 18 }, { 570, 208, 3 }, { 596, 168, -17 }, { 524, 30, -34 }, { 650, 60, -67 },
        },
        {
            { 34, 464, -70 }, { 173, 537, -35 }, { 380, 528, 9 }, { 56, 288, -42 }, { 230, 396, 32 }, { 292, 392, 58 }, { 271, 305, 65 }, { 263, 231, 50 }, { 438, 340, 87 }, { 628, 464, -27 }, { 508, 278, 55 }, { 426, 130, 29 }, { 429, 67, -2 }, { 618, 190, -12 }, { 652, 158, -35 }, { 695, 135, -59 },
        },
        {
            { 83, 513, -56 }, { 50, 414, -47 }, { 101, 399, -20 }, { 229, 461, 16 }, { 77, 243, -27 }, { 460, 500, 10 }, { 228, 262, 49 }, { 206, 174, 18 }, { 402, 304, 101 }, { 575, 411, 2 }, { 645, 525, -59 }, { 541, 245, 27 }, { 472, 110, 10 }, { 485, 57, -17 }, { 668, 174, -45 }, { 610, 50, -56 },
        },
        {
            { 80, 510, -59 }, { 239, 543, -9 }, { 68, 366, -43 }, { 231, 463, 17 }, { 476, 542, 10 }, { 102, 202, -41 }, { 294, 328, 70 }, { 465, 433, 60 }, { 245, 147, 0 }, { 443, 279, 82 }, { 610, 380, 10 }, { 654, 478, -28 }, { 572, 210, 11 }, { 520, 92, -18 }, { 645, 151, -36 }, { 659, 259, -18 },
        },
        {
            { 28, 458, -54 }, { 233, 537, -39 }, { 293, 531, -34 }, { 90, 322, 10 }, { 263, 429, 17 }, { 421, 521, -43 }, { 132, 166, 38 }, { 330, 298, 77 }, { 404, 306, 48 }, { 388, 224, 69 }, { 385, 155, 60 }, { 543, 247, -9 }, { 688, 326, -87 }, { 601, 173, -39 }, { 570, 76, -40 }, { 647, 247, -61 },
        },
        {
            { 82, 512, -54 }, { 35, 399, -54 }, { 184, 482, -4 }, { 345, 537, 13 }, { 116, 282, -12 }, { 296, 396, 67 }, { 464, 498, 23 }, { 166, 134, -22 }, { 369, 271, 93 }, { 345, 181, 46 }, { 533, 303, 40 }, { 530, 234, 30 }, { 644, 412, -21 }, { 654, 366, -21 }, { 628, 134, -38 }, { 621, 61, -60 },
        },
        {
            { 52, 482, -58 }, { 235, 539, -23 }, { 46, 344, -32 }, { 233, 465, 10 }, { 494, 510, -21 }, { 144, 244, 20 }, { 332, 366, 74 }, { 505, 473, -8 }, { 205, 107, 12 }, { 411, 247, 83 }, { 387, 157, 57 }, { 383, 87, 24 }, { 676, 314, -48 }, { 603, 175, -19 }, { 695, 201, -60 }, { 553, 153, -2 },
        },
        {
            { 106, 536, -54 }, { 79, 443, -37 }, { 386, 534, -3 }, { 62, 294, -25 }, { 280, 446, 34 }, { 541, 521, -29 }, { 277, 311, 81 }, { 269, 237, 70 }, { 444, 346, 67 }, { 249, 85, 5 }, { 355, 125, 37 }, { 532, 236, 27 }, { 435, 73, 4 }, { 624, 196, -24 }, { 480, 136, 20 }, { 529, 129, 1 },
        },
        {
            { 54, 484, -62 }, { 178, 542, -35 }, { 307, 545, -8 }, { 235, 467, 12 }, { 83, 249, -24 }, { 525, 505, -11 }, { 485, 449, 23 }, { 212, 180, 24 }, { 308, 210, 68 }, { 481, 317, 62 }, { 297, 67, 1 }, { 403, 107, 24 }, { 578, 216, 7 }, { 491, 63, -12 }, { 674, 180, -44 }, { 555, 155, 2 },
        },
        {
            { 86, 516, -54 }, { 81, 445, -38 }, { 245, 543, -11 }, { 137, 369, 1 }, { 282, 448, 40 }, { 108, 208, -21 }, { 468, 502, 14 }, { 426, 394, 70 }, { 251, 153, 21 }, { 449, 285, 78 }, { 616, 386, -9 }, { 350, 54, -10 }, { 553, 191, 10 }, { 526, 98, -13 }, { 601, 257, 1 }, { 725, 165, -73 },
        },
        {
            { 34, 464, -69 }, { 139, 503, -33 }, { 309, 547, -2 }, { 408, 520, 15 }, { 169, 335, 14 }, { 327, 427, 57 }, { 138, 172, -20 }, { 409, 377, 85 }, { 565, 467, -1 }, { 394, 230, 78 }, { 391, 161, 44 }, { 549, 253, 30 }, { 407, 45, -15 }, { 606, 178, -12 }, { 576, 82, -32 }, { 653, 253, -20 },
        },
        {
            { 88, 518, -61 }, { 41, 405, -55 }, { 290, 528, -5 }, { 139, 371, -3 }, { 466, 532, -9 }, { 302, 402, 55 }, { 570, 534, -36 }, { 172, 140, -5 }, { 448, 350, 73 }, { 602, 438, -16 }, { 339, 109, 27 }, { 536, 240, 34 }, { 680, 318, -34 }, { 469, 41, -15 }, { 662, 168, -38 }, { 627, 67, -50 },
        },
        {
            { 93, 523, -53 }, { 241, 545, -10 }, { 52, 350, -41 }, { 239, 471, 19 }, { 171, 337, 19 }, { 420, 520, 18 }, { 238, 272, 48 }, { 411, 379, 85 }, { 211, 113, -11 }, { 585, 421, 3 }, { 626, 506, -37 }, { 389, 93, 6 }, { 482, 120, 6 }, { 609, 181, -17 }, { 536, 42, -42 }, { 660, 260, -27 },
        },
        {
            { 46, 476, -66 }, { 149, 513, -33 }, { 392, 540, 4 }, { 68, 300, -35 }, { 286, 452, 35 }, { 204, 304, 33 }, { 568, 532, -27 }, { 275, 243, 59 }, { 450, 352, 78 }, { 255, 91, -5 }, { 520, 290, 48 }, { 667, 371, -28 }, { 441, 79, 1 }, { 530, 102, -8 }, { 586, 242, 11 }, { 607, 47, -54 },
        },
        {
            { 60, 490, -63 }, { 162, 526, -32 }, { 303, 541, 0 }, { 241, 473, 14 }, { 89, 255, -29 }, { 531, 511, -4 }, { 240, 274, 47 }, { 512, 480, 14 }, { 414, 316, 103 }, { 687, 523, -65 }, { 303, 73, -7 }, { 553, 257, 29 }, { 696, 334, -38 }, { 597, 169, -10 }, { 580, 86, -32 }, { 601, 201, -4 },
        },
        {
            { 92, 522, -61 }, { 87, 451, -33 }, { 80, 378, -8 }, { 255, 487, -22 }, { 388, 504, -42 }, { 114, 214, 44 }, { 574, 538, -107 }, { 377, 345, 31 }, { 551, 453, -69 }, { 355, 191, 75 }, { 522, 292, -15 }, { 356, 60, 35 }, { 684, 322, -97 }, { 622, 194, -58 }, { 557, 63, -41 }, { 571, 171, -33 },
        },
        {
            { 40, 470, -68 }, { 145, 509, -34 }, { 315, 523, 10 }, { 102, 334, -20 }, { 304, 470, 32 }, { 533, 513, -6 }, { 144, 178, -16 }, { 415, 383, 81 }, { 316, 218, 63 }, { 585, 421, 4 }, { 397, 167, 47 }, { 555, 259, 29 }, { 413, 51, -11 }, { 613, 185, -12 }, { 596, 252, 8 }, { 619, 59, -54 },
        },
        {
            { 55, 485, -59 }, { 147, 511, -30 }, { 396, 544, -1 }, { 145, 377, 4 }, { 28, 194, -58 }, { 351, 451, 46 }, { 576, 540, -38 }, { 278, 246, 68 }, { 454, 356, 69 }, { 357, 193, 64 }, { 615, 385, -11 }, { 542, 246, 27 }, { 656, 424, -37 }, { 475, 47, -20 }, { 640, 146, -39 }, { 608, 208, -11 },
        },
        {
            { 64, 494, -58 }, { 175, 539, -28 }, { 58, 356, -39 }, { 245, 477, 18 }, { 177, 343, 21 }, { 156, 256, 7 }, { 495, 529, -1 }, { 417, 385, 81 }, { 217, 119, -7 }, { 591, 427, -1 }, { 499, 269, 53 }, { 639, 343, -13 }, { 488, 126, 8 }, { 615, 187, -17 }, { 542, 48, -39 }, { 605, 205, -9 },
        },
        {
            { 52, 482, -62 }, { 191, 535, -21 }, { 97, 395, -26 }, { 374, 526, 20 }, { 292, 458, 41 }, { 210, 310, 34 }, { 189, 223, 10 }, { 436, 404, 73 }, { 456, 358, 80 }, { 261, 97, -10 }, { 526, 296, 46 }, { 444, 148, 25 }, { 629, 397, -9 }, { 696, 408, -42 }, { 642, 148, -38 }, { 613, 53, -59 },
        },
        {
            { 66, 496, -54 }, { 168, 532, -28 }, { 319, 527, 7 }, { 122, 354, 0 }, { 95, 261, -12 }, { 337, 437, 53 }, { 246, 280, 64 }, { 124, 92, -36 }, { 475, 377, 49 }, { 593, 429, -14 }, { 309, 79, 6 }, { 559, 263, 16 }, { 490, 128, 10 }, { 634, 346, -21 }, { 486, 142, 16 }, { 667, 107, -64 },
        },
        {
            { 98, 528, -49 }, { 93, 457, -25 }, { 86, 384, -7 }, { 249, 481, 8 }, { 150, 316, 35 }, { 120, 220, 21 }, { 480, 514, -30 }, { 383, 351, 65 }, { 263, 165, 64 }, { 512, 348, 12 }, { 428, 198, 53 }, { 362, 66, 17 }, { 590, 228, -20 }, { 598, 310, -25 }, { 585, 91, -42 }, { 477, 77, -5 },
        },
        {
            { 134, 544, -66 }, { 251, 535, -50 }, { 121, 419, -12 }, { 108, 340, 14 }, { 481, 547, -87 }, { 180, 280, 61 }, { 150, 184, 64 }, { 421, 389, -5 }, { 322, 224, 87 }, { 306, 142, 86 }, { 646, 416, -101 }, { 561, 265, -33 }, { 419, 57, 16 }, { 619, 191, -58 }, { 588, 94, -50 }, { 331, 0, 48 },
        },
        {
            { 100, 530, -65 }, { 218, 542, -52 }, { 102, 400, -10 }, { 251, 483, -21 }, { 134, 300, 36 }, { 414, 514, -52 }, { 314, 348, 44 }, { 184, 152, 71 }, { 560, 462, -75 }, { 363, 199, 73 }, { 451, 221, 28 }, { 677, 381, -103 }, { 692, 330, -101 }, { 481, 53, -9 }, { 646, 152, -70 }, { 639, 79, -75 },
        },
        {
            { 70, 500, -58 }, { 253, 537, -18 }, { 395, 543, -15 }, { 251, 483, 7 }, { 183, 349, 31 }, { 162, 262, 28 }, { 350, 384, 67 }, { 250, 218, 63 }, { 223, 125, 22 }, { 597, 433, -27 }, { 405, 175, 61 }, { 501, 205, 35 }, { 706, 344, -63 }, { 621, 193, -23 }, { 548, 54, -30 }, { 511, 111, 3 },
        },
        {
            { 58, 488, -62 }, { 197, 541, -29 }, { 304, 542, -6 }, { 467, 539, -10 }, { 298, 464, 30 }, { 216, 316, 43 }, { 195, 229, 26 }, { 487, 455, 22 }, { 189, 91, -17 }, { 267, 103, 10 }, { 532, 302, 39 }, { 450, 154, 38 }, { 353, 121, 31 }, { 632, 204, -20 }, { 648, 154, -37 }, { 619, 59, -53 },
        },
        {
            { 72, 502, -55 }, { 74, 438, -37 }, { 225, 523, -10 }, { 253, 485, 13 }, { 431, 547, -11 }, { 343, 443, 47 }, { 252, 286, 68 }, { 130, 98, -30 }, { 426, 328, 82 }, { 331, 167, 53 }, { 315, 85, 12 }, { 565, 269, 14 }, { 596, 234, -4 }, { 509, 81, -13 }, { 656, 162, -45 }, { 513, 113, -1 },
        },
        {
            { 15, 445, -64 }, { 149, 513, -36 }, { 42, 340, -31 }, { 205, 437, 11 }, { 350, 516, -7 }, { 540, 520, -44 }, { 336, 370, 66 }, { 239, 207, 64 }, { 219, 121, 29 }, { 417, 253, 79 }, { 325, 95, 36 }, { 418, 122, 38 }, { 646, 284, -36 }, { 694, 266, -59 }, { 519, 25, -30 }, { 728, 168, -82 },
        },
        {
            { 12, 432, -67 }, { 15, 299, -48 }, { 37, 275, -36 }, { 164, 396, 8 }, { 237, 403, 32 }, { 495, 535, -32 }, { 591, 485, -43 }, { 377, 345, 79 }, { 278, 180, 64 }, { 162, 98, -6 }, { 459, 229, 61 }, { 373, 77, 24 }, { 475, 113, 20 }, { 675, 247, -43 }, { 544, 50, -26 }, { 681, 121, -62 },
        },
        {
            { 56, 486, -57 }, { 29, 373, -48 }, { 257, 525, -5 }, { 207, 439, 17 }, { 90, 256, -14 }, { 270, 370, 64 }, { 438, 472, 23 }, { 537, 505, -18 }, { 416, 318, 88 }, { 319, 155, 47 }, { 307, 77, 8 }, { 504, 208, 34 }, { 523, 161, 12 }, { 437, 149, 36 }, { 702, 208, -59 }, { 595, 35, -57 },
        },
        {
            { 26, 456, -65 }, { 209, 533, -30 }, { 20, 318, -44 }, { 182, 414, 10 }, { 439, 505, -9 }, { 118, 218, 5 }, { 306, 340, 78 }, { 479, 447, 7 }, { 676, 488, -80 }, { 453, 289, 64 }, { 361, 131, 53 }, { 357, 61, 18 }, { 550, 188, 10 }, { 476, 48, -7 }, { 704, 210, -62 }, { 627, 67, -53 },
        },
        {
            { 14, 444, -70 }, { 153, 517, -34 }, { 360, 538, -5 }, { 36, 268, -43 }, { 210, 376, 33 }, { 172, 272, 25 }, { 151, 185, 3 }, { 443, 411, 46 }, { 418, 320, 87 }, { 608, 444, -27 }, { 488, 258, 55 }, { 406, 110, 28 }, { 409, 47, -3 }, { 698, 270, -49 }, { 632, 138, -35 }, { 575, 15, -54 },
        },
        {
            { 63, 493, -60 }, { 30, 394, -26 }, { 281, 549, -75 }, { 209, 441, -18 }, { 57, 223, 37 }, { 240, 340, 31 }, { 208, 242, 81 }, { 186, 154, 106 }, { 482, 384, -54 }, { 355, 191, 47 }, { 635, 405, -120 }, { 521, 225, -37 }, { 452, 90, -6 }, { 565, 137, -57 }, { 598, 254, -78 }, { 430, 30, -8 },
        },
        {
            { 60, 490, -68 }, { 219, 543, -19 }, { 48, 346, -57 }, { 211, 443, 10 }, { 456, 522, 22 }, { 627, 532, -30 }, { 174, 208, -10 }, { 345, 313, 90 }, { 225, 127, -16 }, { 423, 259, 81 }, { 590, 360, 25 }, { 634, 458, -12 }, { 552, 190, 16 }, { 500, 72, -20 }, { 725, 231, -49 }, { 639, 239, -8 },
        },
        {
            { 18, 438, -70 }, { 213, 537, -19 }, { 173, 471, -9 }, { 70, 302, -33 }, { 443, 509, 16 }, { 301, 401, 62 }, { 112, 146, -35 }, { 310, 278, 83 }, { 284, 186, 43 }, { 468, 304, 74 }, { 665, 435, -38 }, { 523, 227, 35 }, { 668, 306, -26 }, { 581, 153, -10 }, { 550, 56, -35 }, { 627, 227, -13 },
        },
        {
            { 62, 492, -54 }, { 15, 379, -33 }, { 264, 532, -39 }, { 225, 457, -4 }, { 96, 262, 28 }, { 276, 376, 39 }, { 444, 478, -37 }, { 146, 114, 40 }, { 349, 251, 78 }, { 325, 161, 83 }, { 313, 83, 51 }, { 510, 214, 1 }, { 454, 92, 11 }, { 634, 346, -73 }, { 608, 114, -55 }, { 601, 41, -66 },
        },
        {
            { 32, 462, -58 }, { 215, 539, -28 }, { 26, 324, -34 }, { 213, 445, 13 }, { 474, 540, -36 }, { 124, 224, 16 }, { 312, 346, 79 }, { 485, 453, -2 }, { 627, 532, -80 }, { 291, 127, 48 }, { 467, 237, 50 }, { 363, 67, 19 }, { 556, 194, 1 }, { 683, 255, -57 }, { 725, 381, -86 }, { 633, 73, -60 },
        },
        {
            { 86, 516, -52 }, { 59, 423, -38 }, { 266, 534, -10 }, { 42, 274, -30 }, { 260, 426, 39 }, { 421, 521, -4 }, { 157, 191, 16 }, { 249, 217, 62 }, { 424, 326, 75 }, { 229, 65, -4 }, { 335, 105, 30 }, { 512, 216, 28 }, { 415, 53, -2 }, { 604, 176, -22 }, { 710, 216, -67 }, { 709, 309, -64 },
        },
        {
            { 34, 464, -57 }, { 158, 522, -31 }, { 87, 385, -15 }, { 215, 447, 16 }, { 63, 229, -18 }, { 405, 505, 1 }, { 365, 399, 57 }, { 192, 160, 28 }, { 388, 290, 92 }, { 561, 397, -8 }, { 277, 47, 2 }, { 483, 187, 33 }, { 358, 126, 43 }, { 471, 43, -16 }, { 654, 160, -50 }, { 635, 75, -61 },
        },
        {
            { 66, 496, -66 }, { 161, 525, -35 }, { 325, 533, 8 }, { 117, 349, -20 }, { 262, 428, 35 }, { 627, 532, -36 }, { 348, 382, 82 }, { 506, 474, 26 }, { 231, 133, -5 }, { 429, 265, 87 }, { 596, 366, 17 }, { 330, 34, -27 }, { 533, 171, 18 }, { 506, 78, -14 }, { 581, 237, 18 }, { 705, 145, -58 },
        },
        {
            { 14, 444, -56 }, { 219, 543, -46 }, { 89, 387, -9 }, { 388, 540, -51 }, { 249, 415, 19 }, { 507, 547, -80 }, { 118, 152, 32 }, { 389, 357, 32 }, { 545, 447, -55 }, { 374, 210, 74 }, { 371, 141, 62 }, { 529, 233, -4 }, { 387, 25, 11 }, { 586, 158, -35 }, { 556, 62, -37 }, { 633, 233, -56 },
        },
        {
            { 68, 498, -59 }, { 21, 385, -52 }, { 270, 538, -18 }, { 219, 451, 11 }, { 446, 512, -10 }, { 182, 282, 38 }, { 350, 384, 64 }, { 152, 120, -3 }, { 528, 430, 0 }, { 482, 318, 48 }, { 319, 89, 28 }, { 416, 120, 36 }, { 660, 298, -38 }, { 649, 221, -34 }, { 542, 48, -29 }, { 707, 147, -71 },
        },
        {
            { 73, 503, -57 }, { 121, 485, -33 }, { 32, 330, -48 }, { 319, 511, 14 }, { 251, 417, 39 }, { 500, 540, -15 }, { 218, 252, 41 }, { 391, 359, 90 }, { 191, 93, -17 }, { 565, 401, 10 }, { 516, 286, 45 }, { 369, 73, 4 }, { 462, 100, 7 }, { 649, 361, -24 }, { 516, 22, -40 }, { 700, 140, -66 },
        },
        {
            { 26, 456, -72 }, { 229, 533, -17 }, { 172, 470, -13 }, { 48, 280, -46 }, { 466, 532, -1 }, { 284, 384, 58 }, { 448, 482, 25 }, { 255, 223, 45 }, { 430, 332, 92 }, { 235, 71, -17 }, { 500, 270, 57 }, { 647, 351, -16 }, { 421, 59, -4 }, { 610, 182, -10 }, { 716, 222, -53 }, { 587, 27, -53 },
        },
        {
            { 40, 470, -73 }, { 142, 506, -40 }, { 383, 531, 5 }, { 221, 453, 7 }, { 69, 235, -43 }, { 511, 491, 7 }, { 220, 254, 33 }, { 592, 480, -16 }, { 294, 196, 49 }, { 467, 303, 81 }, { 283, 53, -15 }, { 533, 237, 41 }, { 676, 314, -24 }, { 477, 49, -14 }, { 660, 166, -32 }, { 641, 81, -48 },
        },
        {
            { 72, 502, -52 }, { 67, 431, -32 }, { 60, 358, -19 }, { 235, 467, 11 }, { 368, 534, -14 }, { 94, 194, -1 }, { 354, 388, 59 }, { 257, 225, 80 }, { 531, 433, -12 }, { 335, 171, 71 }, { 502, 272, 31 }, { 336, 40, 5 }, { 664, 302, -51 }, { 602, 174, -27 }, { 537, 43, -35 }, { 651, 251, -44 },
        },
        {
            { 20, 450, -70 }, { 225, 549, -23 }, { 95, 393, -25 }, { 82, 314, -24 }, { 284, 450, 35 }, { 413, 513, 13 }, { 124, 158, -23 }, { 395, 363, 88 }, { 296, 198, 56 }, { 565, 401, 11 }, { 477, 247, 60 }, { 635, 339, -13 }, { 393, 31, -16 }, { 593, 165, -11 }, { 726, 232, -62 }, { 599, 39, -55 },
        },
        {
            { 35, 465, -68 }, { 27, 291, -54 }, { 276, 544, -11 }, { 125, 357, -8 }, { 308, 474, 28 }, { 431, 531, 2 }, { 256, 290, 60 }, { 158, 126, -19 }, { 434, 336, 86 }, { 337, 173, 53 }, { 695, 465, -60 }, { 522, 226, 37 }, { 666, 304, -26 }, { 455, 27, -23 }, { 620, 126, -31 }, { 648, 88, -53 },
        },
        {
            { 44, 474, -58 }, { 155, 519, -28 }, { 38, 336, -39 }, { 225, 457, 18 }, { 157, 323, 21 }, { 136, 236, 7 }, { 475, 509, -1 }, { 397, 365, 81 }, { 197, 99, -7 }, { 571, 407, -1 }, { 379, 149, 44 }, { 619, 323, -13 }, { 568, 206, 3 }, { 595, 167, -17 }, { 522, 28, -39 }, { 650, 60, -67 },
        },
        {
            { 32, 462, -59 }, { 171, 535, -26 }, { 77, 375, -23 }, { 54, 286, -30 }, { 272, 438, 43 }, { 290, 390, 68 }, { 269, 303, 77 }, { 416, 384, 70 }, { 536, 438, 8 }, { 241, 77, -8 }, { 506, 276, 43 }, { 424, 128, 24 }, { 609, 377, -12 }, { 516, 88, -16 }, { 622, 128, -41 }, { 633, 233, -24 },
        },
        {
            { 46, 476, -54 }, { 148, 512, -25 }, { 99, 397, -12 }, { 202, 434, 22 }, { 75, 241, -18 }, { 417, 517, 5 }, { 226, 260, 58 }, { 204, 172, 26 }, { 455, 357, 57 }, { 573, 409, -7 }, { 289, 59, -3 }, { 539, 243, 19 }, { 470, 108, 6 }, { 614, 326, -16 }, { 566, 72, -38 }, { 587, 187, -13 },
        },
        {
            { 78, 508, -54 }, { 73, 437, -39 }, { 66, 364, -31 }, { 229, 461, 18 }, { 130, 296, 4 }, { 200, 300, 39 }, { 460, 494, 15 }, { 463, 431, 40 }, { 243, 145, 20 }, { 492, 328, 54 }, { 508, 278, 46 }, { 342, 46, -11 }, { 670, 308, -34 }, { 518, 90, -14 }, { 665, 171, -46 }, { 657, 257, -30 },
        },
        {
            { 114, 544, -53 }, { 31, 395, -48 }, { 201, 499, -8 }, { 388, 540, -6 }, { 261, 427, 39 }, { 160, 260, 23 }, { 130, 164, -7 }, { 401, 369, 74 }, { 302, 204, 70 }, { 286, 122, 29 }, { 526, 296, 33 }, { 641, 345, -27 }, { 399, 37, -9 }, { 599, 171, -18 }, { 568, 74, -33 }, { 611, 211, -16 },
        },
        {
            { 80, 510, -60 }, { 298, 542, -8 }, { 182, 480, -11 }, { 131, 363, -4 }, { 114, 280, -8 }, { 394, 494, 20 }, { 394, 428, 53 }, { 164, 132, -11 }, { 440, 342, 78 }, { 343, 179, 60 }, { 431, 201, 63 }, { 657, 361, -28 }, { 572, 210, 10 }, { 461, 33, -19 }, { 626, 132, -33 }, { 619, 59, -52 },
        },
        {
            { 50, 480, -59 }, { 233, 537, -55 }, { 375, 523, -59 }, { 231, 463, -18 }, { 163, 329, 35 }, { 142, 242, 57 }, { 330, 364, 24 }, { 230, 198, 106 }, { 303, 205, 94 }, { 577, 413, -76 }, { 585, 355, -65 }, { 381, 85, 39 }, { 586, 224, -46 }, { 601, 173, -53 }, { 528, 34, -36 }, { 691, 291, -104 },
        },
        {
            { 38, 468, -65 }, { 177, 541, -43 }, { 384, 532, -17 }, { 447, 519, -19 }, { 278, 444, 22 }, { 196, 296, 44 }, { 175, 209, 31 }, { 367, 335, 81 }, { 269, 171, 62 }, { 247, 83, 19 }, { 512, 282, 36 }, { 430, 134, 44 }, { 433, 71, 16 }, { 612, 184, -19 }, { 728, 234, -72 }, { 699, 139, -67 },
        },
        {
            { 52, 482, -66 }, { 154, 518, -35 }, { 305, 543, -6 }, { 233, 465, 11 }, { 511, 527, -12 }, { 423, 403, 64 }, { 232, 266, 45 }, { 210, 178, 16 }, { 406, 308, 105 }, { 411, 247, 88 }, { 295, 65, -5 }, { 645, 349, -16 }, { 476, 114, 14 }, { 489, 61, -13 }, { 636, 142, -32 }, { 553, 153, 5 },
        },
        {
            { 45, 475, -66 }, { 179, 543, -32 }, { 72, 370, -36 }, { 235, 467, 14 }, { 380, 546, 3 }, { 570, 490, -10 }, { 366, 400, 76 }, { 269, 237, 53 }, { 249, 151, 17 }, { 447, 283, 83 }, { 355, 125, 26 }, { 348, 52, -11 }, { 676, 314, -28 }, { 524, 96, -10 }, { 649, 155, -36 }, { 698, 298, -40 },
        },
        {
            { 32, 462, -68 }, { 165, 529, -36 }, { 307, 545, -10 }, { 94, 326, -17 }, { 267, 433, 34 }, { 525, 505, -13 }, { 621, 515, -50 }, { 407, 375, 74 }, { 308, 210, 70 }, { 292, 128, 30 }, { 689, 459, -62 }, { 403, 107, 26 }, { 405, 43, -6 }, { 605, 177, -12 }, { 574, 80, -28 }, { 651, 251, -24 },
        },
        {
            { 86, 516, -58 }, { 39, 403, -54 }, { 87, 385, -29 }, { 237, 469, 14 }, { 120, 286, -8 }, { 200, 300, 33 }, { 468, 502, 13 }, { 667, 475, -48 }, { 446, 348, 80 }, { 349, 185, 56 }, { 437, 207, 60 }, { 634, 338, -10 }, { 453, 91, 4 }, { 567, 139, -8 }, { 582, 238, 11 }, { 625, 65, -55 },
        },
        {
            { 56, 486, -54 }, { 139, 503, -28 }, { 50, 348, -28 }, { 212, 444, 18 }, { 169, 335, 31 }, { 148, 248, 23 }, { 336, 370, 77 }, { 509, 477, -8 }, { 606, 508, -54 }, { 483, 319, 46 }, { 391, 161, 53 }, { 387, 91, 20 }, { 580, 218, -5 }, { 506, 78, -13 }, { 634, 140, -44 }, { 697, 297, -59 },
        },
        {
            { 44, 474, -69 }, { 183, 547, -35 }, { 390, 538, 6 }, { 66, 298, -39 }, { 140, 306, -2 }, { 302, 402, 58 }, { 281, 315, 68 }, { 273, 241, 54 }, { 448, 350, 83 }, { 638, 474, -31 }, { 518, 288, 52 }, { 436, 140, 31 }, { 439, 77, 0 }, { 728, 300, -52 }, { 662, 168, -36 }, { 605, 45, -52 },
        },
        {
            { 93, 523, -54 }, { 60, 424, -44 }, { 211, 509, -7 }, { 239, 471, 17 }, { 87, 253, -23 }, { 270, 370, 63 }, { 238, 272, 52 }, { 216, 184, 21 }, { 412, 314, 98 }, { 585, 421, -2 }, { 655, 535, -62 }, { 551, 255, 25 }, { 482, 120, 9 }, { 495, 67, -17 }, { 678, 184, -47 }, { 620, 60, -57 },
        },
        {
            { 90, 520, -55 }, { 249, 533, -17 }, { 78, 376, -20 }, { 241, 473, 10 }, { 486, 502, -15 }, { 112, 212, 3 }, { 304, 338, 84 }, { 275, 243, 85 }, { 255, 157, 48 }, { 453, 289, 62 }, { 620, 390, -32 }, { 564, 388, -7 }, { 352, 120, 42 }, { 530, 102, -9 }, { 555, 61, -32 }, { 729, 169, -82 },
        },
        {
            { 38, 468, -69 }, { 143, 507, -33 }, { 303, 541, 2 }, { 100, 332, -23 }, { 273, 439, 38 }, { 531, 511, 0 }, { 142, 176, -22 }, { 240, 208, 28 }, { 414, 316, 106 }, { 498, 334, 64 }, { 395, 165, 43 }, { 553, 257, 31 }, { 698, 336, -36 }, { 611, 183, -12 }, { 580, 86, -32 }, { 657, 257, -19 },
        },
        {
            { 92, 522, -57 }, { 45, 409, -50 }, { 294, 532, -3 }, { 255, 487, 10 }, { 126, 292, 0 }, { 206, 306, 40 }, { 474, 508, 1 }, { 176, 144, -1 }, { 379, 281, 110 }, { 255, 91, 3 }, { 343, 113, 28 }, { 540, 244, 29 }, { 684, 322, -40 }, { 704, 276, -50 }, { 638, 144, -36 }, { 631, 71, -54 },
        },
        {
            { 62, 492, -54 }, { 145, 509, -30 }, { 56, 354, -25 }, { 243, 475, 11 }, { 404, 520, -6 }, { 154, 254, 29 }, { 342, 376, 71 }, { 515, 483, -16 }, { 215, 117, 20 }, { 421, 257, 76 }, { 497, 267, 39 }, { 393, 97, 25 }, { 386, 24, -9 }, { 613, 185, -26 }, { 705, 211, -68 }, { 703, 303, -64 },
        },
        {
            { 116, 546, -56 }, { 89, 453, -32 }, { 396, 544, -24 }, { 72, 304, -9 }, { 290, 456, 22 }, { 551, 531, -54 }, { 187, 221, 47 }, { 379, 347, 71 }, { 554, 456, -29 }, { 259, 95, 29 }, { 365, 135, 53 }, { 542, 246, 12 }, { 445, 83, 12 }, { 534, 106, -10 }, { 590, 246, -12 }, { 339, 0, 18 },
        },
        {
            { 64, 494, -65 }, { 188, 532, -30 }, { 317, 525, 4 }, { 245, 477, 9 }, { 93, 259, -25 }, { 535, 515, -12 }, { 595, 489, -23 }, { 222, 190, 24 }, { 318, 220, 69 }, { 491, 327, 63 }, { 307, 77, 3 }, { 413, 117, 26 }, { 588, 226, 9 }, { 501, 73, -9 }, { 684, 190, -42 }, { 505, 105, 3 },
        },
        {
            { 96, 526, -53 }, { 91, 455, -36 }, { 255, 523, -1 }, { 147, 379, 5 }, { 292, 458, 37 }, { 118, 218, -12 }, { 478, 512, 4 }, { 436, 404, 61 }, { 261, 163, 30 }, { 459, 295, 73 }, { 626, 396, -17 }, { 360, 64, -3 }, { 463, 101, 5 }, { 636, 208, -24 }, { 561, 67, -35 }, { 575, 175, -4 },
        },
        {
            { 44, 474, -67 }, { 149, 513, -36 }, { 319, 527, 0 }, { 418, 530, -2 }, { 179, 345, 21 }, { 337, 437, 46 }, { 148, 182, -4 }, { 419, 387, 66 }, { 575, 477, -19 }, { 304, 140, 37 }, { 501, 271, 53 }, { 659, 363, -29 }, { 417, 55, 0 }, { 616, 188, -14 }, { 686, 192, -46 }, { 623, 63, -51 },
        },
        {
            { 98, 528, -61 }, { 51, 415, -55 }, { 300, 538, -5 }, { 149, 381, -3 }, { 476, 542, -9 }, { 312, 412, 55 }, { 580, 544, -36 }, { 182, 150, -5 }, { 458, 360, 73 }, { 612, 448, -16 }, { 349, 119, 27 }, { 546, 250, 34 }, { 690, 328, -34 }, { 479, 51, -15 }, { 672, 178, -38 }, { 637, 77, -50 },
        },
        {
            { 103, 533, -52 }, { 251, 535, -3 }, { 62, 360, -38 }, { 249, 481, 19 }, { 181, 347, 21 }, { 430, 530, 13 }, { 248, 282, 52 }, { 421, 389, 80 }, { 221, 123, -6 }, { 595, 431, -2 }, { 636, 516, -42 }, { 499, 203, 34 }, { 492, 130, 7 }, { 619, 191, -18 }, { 546, 52, -40 }, { 470, 70, -15 },
        },
        {
            { 56, 486, -63 }, { 159, 523, -31 }, { 202, 500, -8 }, { 78, 310, -32 }, { 396, 512, 23 }, { 214, 314, 36 }, { 578, 542, -29 }, { 285, 253, 62 }, { 460, 362, 75 }, { 265, 101, -3 }, { 530, 300, 45 }, { 677, 381, -31 }, { 451, 89, 0 }, { 540, 112, -10 }, { 596, 252, 8 }, { 617, 57, -56 },
        },
        {
            { 70, 500, -60 }, { 72, 436, -44 }, { 213, 511, -9 }, { 251, 483, 14 }, { 99, 265, -20 }, { 441, 541, 0 }, { 250, 284, 56 }, { 522, 490, 4 }, { 424, 326, 95 }, { 697, 533, -75 }, { 313, 83, 2 }, { 563, 267, 24 }, { 706, 344, -46 }, { 507, 79, -13 }, { 690, 196, -47 }, { 671, 111, -58 },
        },
        {
            { 102, 532, -59 }, { 97, 461, -30 }, { 90, 388, -4 }, { 265, 497, -22 }, { 398, 514, -43 }, { 124, 224, 48 }, { 584, 548, -110 }, { 387, 355, 28 }, { 561, 463, -72 }, { 365, 201, 71 }, { 532, 302, -19 }, { 366, 70, 33 }, { 594, 232, -43 }, { 592, 304, -49 }, { 567, 73, -45 }, { 581, 181, -38 },
        },
        {
            { 50, 480, -66 }, { 155, 519, -33 }, { 325, 533, 7 }, { 112, 344, -17 }, { 314, 480, 31 }, { 543, 523, -10 }, { 154, 188, -12 }, { 425, 393, 77 }, { 326, 228, 67 }, { 595, 431, 0 }, { 407, 177, 50 }, { 565, 269, 27 }, { 423, 61, -9 }, { 623, 195, -14 }, { 506, 162, 22 }, { 629, 69, -54 },
        },
        {
            { 15, 445, -56 }, { 27, 371, -36 }, { 256, 524, -10 }, { 205, 437, 19 }, { 88, 254, 2 }, { 411, 511, -7 }, { 336, 370, 71 }, { 138, 106, -4 }, { 514, 416, 1 }, { 317, 153, 60 }, { 575, 345, -11 }, { 502, 206, 24 }, { 546, 184, 0 }, { 435, 147, 36 }, { 650, 306, -44 }, { 628, 68, -64 },
        },
        {
            { 24, 454, -66 }, { 15, 299, -47 }, { 38, 216, -37 }, { 205, 437, 10 }, { 137, 303, 13 }, { 416, 516, -7 }, { 355, 389, 61 }, { 477, 445, 12 }, { 627, 532, -71 }, { 451, 287, 68 }, { 359, 129, 49 }, { 599, 303, -7 }, { 448, 86, 15 }, { 575, 147, -9 }, { 702, 208, -60 }, { 625, 65, -52 },
        },
        {
            { 12, 442, -58 }, { 151, 515, -31 }, { 57, 355, -19 }, { 34, 266, -23 }, { 252, 418, 37 }, { 270, 370, 62 }, { 149, 183, 24 }, { 496, 464, -12 }, { 416, 318, 66 }, { 221, 57, 4 }, { 486, 256, 38 }, { 404, 108, 31 }, { 619, 257, -29 }, { 496, 68, -12 }, { 602, 108, -41 }, { 473, 73, -3 },
        },
        {
            { 26, 456, -64 }, { 28, 292, -31 }, { 39, 277, -24 }, { 42, 114, -35 }, { 155, 321, 26 }, { 397, 497, -13 }, { 206, 240, 60 }, { 184, 152, 37 }, { 435, 337, 47 }, { 453, 289, 52 }, { 269, 39, 15 }, { 619, 323, -32 }, { 450, 88, 22 }, { 634, 206, -35 }, { 646, 152, -46 }, { 627, 67, -54 },
        },
        {
            { 58, 488, -57 }, { 153, 517, -35 }, { 46, 344, -27 }, { 209, 441, 12 }, { 110, 276, 11 }, { 627, 532, -82 }, { 340, 374, 63 }, { 243, 211, 71 }, { 223, 125, 35 }, { 572, 408, -23 }, { 488, 258, 40 }, { 322, 26, 3 }, { 550, 188, 3 }, { 598, 170, -22 }, { 595, 251, -14 }, { 597, 37, -55 },
        },
        {
            { 94, 524, -58 }, { 111, 475, -33 }, { 81, 379, -8 }, { 268, 500, -19 }, { 441, 507, -42 }, { 140, 240, 48 }, { 110, 144, 25 }, { 381, 349, 40 }, { 382, 284, 62 }, { 266, 102, 59 }, { 506, 276, 6 }, { 621, 325, -56 }, { 379, 17, 7 }, { 579, 151, -32 }, { 548, 54, -37 }, { 591, 191, -34 },
        },
        {
            { 60, 490, -56 }, { 178, 542, -34 }, { 362, 540, -9 }, { 111, 343, -1 }, { 94, 260, -6 }, { 374, 474, 23 }, { 274, 308, 82 }, { 144, 112, -12 }, { 420, 322, 78 }, { 323, 159, 57 }, { 311, 81, 18 }, { 537, 241, 22 }, { 452, 90, 10 }, { 541, 113, -10 }, { 706, 212, -64 }, { 639, 239, -29 },
        },
        {
            { 30, 460, -59 }, { 213, 537, -28 }, { 355, 533, -16 }, { 211, 443, 13 }, { 143, 309, 25 }, { 122, 222, 15 }, { 310, 344, 79 }, { 210, 178, 47 }, { 627, 532, -81 }, { 457, 293, 54 }, { 465, 235, 50 }, { 361, 65, 19 }, { 666, 304, -50 }, { 581, 153, -18 }, { 508, 14, -34 }, { 471, 71, 0 },
        },
        {
            { 18, 448, -60 }, { 157, 521, -55 }, { 364, 542, -62 }, { 427, 539, -71 }, { 258, 424, 3 }, { 176, 276, 56 }, { 155, 189, 62 }, { 347, 315, 47 }, { 349, 251, 71 }, { 227, 63, 53 }, { 592, 362, -62 }, { 410, 114, 41 }, { 413, 51, 20 }, { 692, 264, -94 }, { 608, 114, -53 }, { 579, 19, -56 },
        },
        {
            { 32, 462, -67 }, { 14, 298, -52 }, { 15, 283, -51 }, { 213, 445, 10 }, { 391, 507, 4 }, { 503, 543, -31 }, { 212, 246, 45 }, { 190, 158, 17 }, { 486, 388, 36 }, { 491, 327, 49 }, { 275, 45, -4 }, { 525, 229, 33 }, { 456, 94, 15 }, { 569, 141, -6 }, { 716, 222, -62 }, { 633, 73, -52 },
        },
        {
            { 25, 455, -58 }, { 159, 523, -35 }, { 52, 350, -22 }, { 215, 447, 12 }, { 360, 526, -14 }, { 550, 530, -56 }, { 346, 380, 59 }, { 249, 217, 77 }, { 229, 131, 41 }, { 427, 263, 68 }, { 335, 105, 42 }, { 328, 32, 6 }, { 556, 194, -1 }, { 504, 76, -9 }, { 729, 235, -83 }, { 578, 178, -14 },
        },
        {
            { 12, 442, -83 }, { 145, 509, -39 }, { 87, 385, -40 }, { 374, 526, 14 }, { 247, 413, 30 }, { 505, 545, -6 }, { 601, 495, -15 }, { 387, 355, 100 }, { 288, 190, 36 }, { 372, 208, 64 }, { 569, 339, 34 }, { 383, 87, 5 }, { 485, 123, 14 }, { 685, 257, -26 }, { 554, 60, -30 }, { 691, 131, -53 },
        },
        {
            { 66, 496, -59 }, { 19, 383, -58 }, { 267, 535, -8 }, { 217, 449, 14 }, { 100, 266, -13 }, { 280, 380, 61 }, { 448, 482, 19 }, { 547, 515, -22 }, { 426, 328, 86 }, { 329, 165, 51 }, { 317, 87, 13 }, { 514, 218, 35 }, { 533, 171, 15 }, { 447, 19, -25 }, { 712, 218, -58 }, { 605, 45, -54 },
        },
        {
            { 36, 466, -58 }, { 219, 543, -28 }, { 30, 328, -33 }, { 292, 524, -9 }, { 249, 415, 36 }, { 128, 228, 17 }, { 316, 350, 79 }, { 489, 457, -3 }, { 686, 498, -91 }, { 463, 299, 53 }, { 371, 141, 53 }, { 367, 71, 20 }, { 560, 198, 0 }, { 586, 158, -19 }, { 514, 20, -34 }, { 477, 77, 0 },
        },
        {
            { 24, 454, -64 }, { 163, 527, -32 }, { 370, 548, -8 }, { 46, 278, -34 }, { 220, 386, 38 }, { 182, 282, 34 }, { 61, 95, -57 }, { 453, 421, 39 }, { 428, 330, 79 }, { 618, 454, -35 }, { 498, 268, 47 }, { 416, 120, 29 }, { 419, 57, -2 }, { 608, 180, -19 }, { 542, 48, -34 }, { 625, 225, -19 },
        },
        {
            { 73, 503, -56 }, { 40, 404, -44 }, { 91, 389, -18 }, { 219, 451, 14 }, { 67, 233, -20 }, { 250, 350, 61 }, { 218, 252, 56 }, { 196, 164, 28 }, { 492, 394, 25 }, { 465, 301, 58 }, { 645, 415, -46 }, { 531, 235, 24 }, { 462, 100, 13 }, { 475, 47, -13 }, { 658, 164, -48 }, { 600, 40, -55 },
        },
        {
            { 70, 500, -55 }, { 229, 533, -14 }, { 58, 356, -31 }, { 221, 453, 17 }, { 466, 532, -11 }, { 92, 192, -20 }, { 84, 118, -41 }, { 255, 223, 59 }, { 235, 137, 21 }, { 433, 269, 78 }, { 600, 370, -9 }, { 644, 468, -49 }, { 562, 200, 5 }, { 510, 82, -12 }, { 485, 141, 19 }, { 709, 149, -72 },
        },
        {
            { 18, 448, -68 }, { 223, 547, -17 }, { 183, 481, -5 }, { 80, 312, -25 }, { 453, 519, 10 }, { 311, 411, 63 }, { 122, 156, -27 }, { 320, 288, 91 }, { 394, 296, 105 }, { 278, 114, 9 }, { 575, 345, 16 }, { 533, 237, 30 }, { 648, 416, -28 }, { 591, 163, -14 }, { 560, 66, -36 }, { 637, 237, -19 },
        },
        {
            { 72, 502, -49 }, { 25, 389, -46 }, { 174, 472, -1 }, { 335, 527, 8 }, { 106, 272, -1 }, { 286, 386, 69 }, { 454, 488, 13 }, { 156, 124, -10 }, { 359, 261, 98 }, { 335, 171, 53 }, { 223, 103, 3 }, { 520, 224, 25 }, { 664, 302, -39 }, { 604, 456, -30 }, { 618, 124, -43 }, { 611, 51, -63 },
        },
        {
            { 42, 472, -58 }, { 225, 549, -33 }, { 36, 334, -31 }, { 223, 455, 10 }, { 484, 500, -22 }, { 134, 234, 22 }, { 322, 356, 73 }, { 495, 463, -10 }, { 195, 97, 14 }, { 301, 137, 56 }, { 477, 247, 46 }, { 373, 77, 25 }, { 666, 304, -50 }, { 593, 165, -20 }, { 535, 191, 11 }, { 643, 83, -61 },
        },
        {
            { 96, 526, -53 }, { 69, 433, -39 }, { 276, 544, -8 }, { 52, 284, -33 }, { 270, 436, 40 }, { 431, 531, 0 }, { 267, 301, 74 }, { 259, 227, 58 }, { 434, 336, 79 }, { 239, 75, -8 }, { 345, 115, 27 }, { 522, 226, 30 }, { 425, 63, -4 }, { 614, 186, -20 }, { 720, 226, -65 }, { 719, 319, -61 },
        },
        {
            { 44, 474, -55 }, { 168, 532, -49 }, { 97, 395, -8 }, { 225, 457, -5 }, { 73, 239, 17 }, { 415, 515, -46 }, { 375, 409, 11 }, { 202, 170, 77 }, { 298, 200, 108 }, { 471, 307, 13 }, { 287, 57, 42 }, { 493, 197, 12 }, { 468, 106, 11 }, { 481, 53, -9 }, { 664, 170, -74 }, { 645, 85, -74 },
        },
        {
            { 76, 506, -54 }, { 71, 435, -38 }, { 235, 533, -11 }, { 127, 359, 1 }, { 272, 438, 40 }, { 98, 198, -21 }, { 358, 392, 76 }, { 516, 484, 0 }, { 241, 143, 21 }, { 439, 275, 78 }, { 606, 376, -9 }, { 340, 44, -10 }, { 543, 181, 10 }, { 516, 88, -13 }, { 591, 247, 1 }, { 715, 155, -73 },
        },
        {
            { 24, 454, -76 }, { 229, 533, -20 }, { 99, 397, -31 }, { 398, 510, 16 }, { 259, 425, 32 }, { 517, 497, 3 }, { 128, 162, -27 }, { 399, 367, 87 }, { 555, 457, 5 }, { 384, 220, 79 }, { 381, 151, 45 }, { 539, 243, 38 }, { 397, 35, -13 }, { 596, 168, -5 }, { 566, 72, -26 }, { 703, 143, -58 },
        },
        {
            { 78, 508, -60 }, { 31, 395, -60 }, { 180, 478, -9 }, { 329, 521, 15 }, { 456, 522, 11 }, { 192, 292, 24 }, { 360, 394, 80 }, { 162, 130, -25 }, { 538, 440, 22 }, { 592, 428, 2 }, { 329, 99, 7 }, { 426, 130, 23 }, { 570, 208, 12 }, { 619, 331, 2 }, { 552, 58, -35 }, { 717, 157, -65 },
        },
        {
            { 83, 513, -59 }, { 131, 495, -34 }, { 42, 340, -51 }, { 329, 521, 15 }, { 261, 427, 38 }, { 510, 490, 13 }, { 228, 262, 37 }, { 401, 369, 93 }, { 201, 103, -20 }, { 675, 511, -55 }, { 526, 296, 48 }, { 379, 83, 3 }, { 472, 110, 7 }, { 659, 371, -20 }, { 526, 32, -39 }, { 710, 150, -64 },
        },
        {
            { 36, 466, -72 }, { 139, 503, -37 }, { 382, 530, 13 }, { 58, 290, -46 }, { 276, 442, 35 }, { 294, 394, 58 }, { 458, 492, 25 }, { 265, 233, 45 }, { 440, 342, 92 }, { 245, 81, -18 }, { 510, 280, 57 }, { 657, 361, -16 }, { 431, 69, -5 }, { 620, 192, -11 }, { 726, 232, -53 }, { 697, 137, -58 },
        },
        {
            { 50, 480, -65 }, { 152, 516, -34 }, { 393, 541, 0 }, { 231, 463, 12 }, { 79, 245, -30 }, { 521, 501, -3 }, { 230, 264, 45 }, { 502, 470, 15 }, { 404, 306, 105 }, { 677, 513, -64 }, { 293, 63, -6 }, { 543, 247, 31 }, { 686, 324, -36 }, { 487, 59, -14 }, { 670, 176, -41 }, { 551, 151, 4 },
        },
        {
            { 82, 512, -52 }, { 77, 441, -33 }, { 70, 368, -21 }, { 245, 477, 13 }, { 378, 544, -11 }, { 104, 204, -5 }, { 364, 398, 63 }, { 367, 335, 92 }, { 541, 443, -8 }, { 345, 181, 68 }, { 512, 282, 34 }, { 346, 50, 2 }, { 674, 312, -47 }, { 612, 184, -25 }, { 547, 53, -35 }, { 661, 261, -41 },
        },
        {
            { 30, 460, -57 }, { 235, 539, -50 }, { 105, 403, -10 }, { 92, 324, 12 }, { 494, 510, -72 }, { 323, 423, 5 }, { 134, 168, 51 }, { 405, 373, 10 }, { 306, 208, 101 }, { 575, 411, -66 }, { 387, 157, 57 }, { 545, 249, -20 }, { 403, 41, 16 }, { 603, 175, -48 }, { 486, 142, 7 }, { 609, 49, -66 },
        },
        {
            { 45, 475, -60 }, { 137, 501, -29 }, { 386, 534, 6 }, { 135, 367, 2 }, { 118, 284, -4 }, { 341, 441, 52 }, { 266, 300, 71 }, { 168, 136, -10 }, { 444, 346, 76 }, { 347, 183, 57 }, { 605, 375, -5 }, { 532, 236, 29 }, { 646, 414, -31 }, { 465, 37, -24 }, { 630, 136, -38 }, { 558, 158, -3 },
        },
        {
            { 54, 484, -59 }, { 165, 529, -28 }, { 48, 346, -42 }, { 235, 467, 18 }, { 167, 333, 18 }, { 146, 246, 3 }, { 485, 519, 3 }, { 407, 375, 85 }, { 207, 109, -11 }, { 581, 417, 3 }, { 489, 259, 54 }, { 629, 333, -10 }, { 478, 116, 7 }, { 605, 177, -16 }, { 532, 38, -41 }, { 695, 295, -43 },
        },
        {
            { 42, 472, -57 }, { 181, 545, -29 }, { 87, 385, -19 }, { 44, 196, -41 }, { 282, 448, 38 }, { 200, 300, 45 }, { 179, 213, 24 }, { 426, 394, 59 }, { 546, 448, -3 }, { 251, 87, 3 }, { 516, 286, 37 }, { 434, 138, 29 }, { 619, 387, -22 }, { 526, 98, -13 }, { 632, 138, -42 }, { 643, 243, -29 },
        },
        {
            { 56, 486, -55 }, { 158, 522, -27 }, { 309, 547, -3 }, { 112, 344, -3 }, { 85, 251, -17 }, { 327, 427, 57 }, { 236, 270, 58 }, { 214, 182, 27 }, { 465, 367, 56 }, { 583, 419, -8 }, { 299, 69, -1 }, { 549, 253, 19 }, { 480, 118, 8 }, { 624, 336, -16 }, { 576, 82, -37 }, { 597, 197, -13 },
        },
        {
            { 88, 518, -49 }, { 83, 447, -27 }, { 76, 374, -13 }, { 239, 471, 13 }, { 140, 306, 27 }, { 110, 210, 9 }, { 470, 504, -16 }, { 373, 341, 78 }, { 253, 155, 51 }, { 502, 338, 25 }, { 518, 288, 22 }, { 352, 56, 10 }, { 650, 418, -59 }, { 528, 100, -15 }, { 625, 281, -32 }, { 627, 67, -64 },
        },
        {
            { 124, 544, -52 }, { 241, 545, -17 }, { 111, 409, -19 }, { 98, 330, -15 }, { 471, 537, -8 }, { 170, 270, 20 }, { 140, 174, -10 }, { 411, 379, 76 }, { 312, 214, 68 }, { 396, 232, 82 }, { 636, 406, -24 }, { 551, 255, 25 }, { 409, 47, -9 }, { 609, 181, -15 }, { 578, 84, -31 }, { 621, 221, -13 },
        },
        {
            { 90, 520, -57 }, { 208, 532, -22 }, { 92, 390, -23 }, { 241, 473, 12 }, { 124, 290, 2 }, { 204, 304, 42 }, { 404, 438, 44 }, { 174, 142, 0 }, { 450, 352, 67 }, { 353, 189, 68 }, { 441, 211, 63 }, { 667, 371, -38 }, { 582, 220, 3 }, { 471, 43, -17 }, { 636, 142, -37 }, { 629, 69, -55 },
        },
        {
            { 60, 490, -56 }, { 143, 507, -32 }, { 385, 533, -13 }, { 241, 473, 9 }, { 173, 339, 32 }, { 152, 252, 27 }, { 340, 374, 69 }, { 240, 208, 62 }, { 213, 115, 20 }, { 587, 423, -26 }, { 495, 265, 41 }, { 391, 95, 27 }, { 696, 334, -62 }, { 611, 183, -24 }, { 538, 44, -32 }, { 601, 201, -17 },
        },
        {
            { 48, 478, -66 }, { 187, 531, -28 }, { 394, 542, 0 }, { 357, 429, 56 }, { 388, 504, 19 }, { 206, 306, 36 }, { 185, 219, 16 }, { 577, 545, -38 }, { 279, 181, 43 }, { 157, 93, -31 }, { 522, 292, 47 }, { 440, 144, 35 }, { 443, 81, 5 }, { 622, 194, -15 }, { 588, 244, 10 }, { 609, 49, -52 },
        },
        {
            { 62, 492, -65 }, { 164, 528, -36 }, { 315, 523, 4 }, { 243, 475, 10 }, { 521, 537, -18 }, { 433, 413, 58 }, { 242, 276, 51 }, { 220, 188, 23 }, { 416, 318, 99 }, { 421, 257, 89 }, { 305, 75, 2 }, { 655, 359, -21 }, { 486, 124, 16 }, { 699, 271, -41 }, { 646, 152, -33 }, { 703, 303, -42 },
        },
        {
            { 55, 485, -68 }, { 189, 533, -28 }, { 82, 380, -37 }, { 245, 477, 11 }, { 390, 506, 24 }, { 580, 500, -13 }, { 476, 440, 44 }, { 279, 247, 56 }, { 259, 161, 20 }, { 457, 293, 84 }, { 465, 235, 65 }, { 358, 62, -7 }, { 686, 324, -29 }, { 534, 106, -7 }, { 559, 65, -31 }, { 608, 208, -2 },
        },
        {
            { 42, 472, -73 }, { 175, 539, -40 }, { 317, 525, 2 }, { 104, 336, -22 }, { 277, 443, 30 }, { 535, 515, -11 }, { 631, 525, -47 }, { 417, 385, 75 }, { 318, 220, 67 }, { 302, 138, 29 }, { 699, 469, -58 }, { 513, 217, 45 }, { 415, 53, -4 }, { 615, 187, -7 }, { 684, 190, -38 }, { 621, 61, -47 },
        },
        {
            { 96, 526, -61 }, { 49, 413, -57 }, { 97, 395, -31 }, { 247, 479, 11 }, { 130, 296, -9 }, { 210, 310, 31 }, { 478, 512, 11 }, { 677, 485, -48 }, { 456, 358, 79 }, { 359, 195, 59 }, { 447, 217, 64 }, { 644, 348, -9 }, { 563, 201, 16 }, { 477, 49, -19 }, { 642, 148, -31 }, { 635, 75, -52 },
        },
        {
            { 66, 496, -61 }, { 149, 513, -30 }, { 60, 358, -46 }, { 222, 454, 17 }, { 179, 345, 14 }, { 158, 258, -3 }, { 346, 380, 89 }, { 519, 487, 21 }, { 616, 518, -24 }, { 593, 429, 9 }, { 401, 171, 37 }, { 497, 201, 34 }, { 690, 328, -29 }, { 516, 88, -19 }, { 644, 150, -37 }, { 607, 207, -6 },
        },
        {
            { 54, 484, -61 }, { 193, 537, -27 }, { 400, 548, -8 }, { 76, 308, -23 }, { 250, 416, 38 }, { 212, 312, 45 }, { 191, 225, 27 }, { 483, 451, 21 }, { 458, 360, 62 }, { 648, 484, -52 }, { 528, 298, 37 }, { 446, 150, 36 }, { 449, 87, 7 }, { 598, 310, 2 }, { 672, 178, -46 }, { 615, 55, -54 },
        },
        {
            { 103, 533, -52 }, { 70, 434, -41 }, { 321, 529, 10 }, { 249, 481, 18 }, { 97, 263, -18 }, { 280, 380, 65 }, { 248, 282, 58 }, { 126, 94, -44 }, { 422, 324, 93 }, { 595, 431, -7 }, { 665, 545, -68 }, { 561, 265, 21 }, { 492, 130, 9 }, { 505, 77, -17 }, { 688, 194, -51 }, { 470, 70, -12 },
        },
        {
            { 100, 530, -54 }, { 259, 543, -23 }, { 88, 386, -14 }, { 251, 483, 5 }, { 496, 512, -28 }, { 122, 222, 14 }, { 314, 348, 79 }, { 285, 253, 97 }, { 265, 167, 61 }, { 463, 299, 51 }, { 630, 400, -44 }, { 674, 498, -88 }, { 692, 330, -64 }, { 540, 112, -11 }, { 565, 71, -33 }, { 479, 79, 0 },
        },
        {
            { 48, 478, -66 }, { 153, 517, -31 }, { 313, 521, 16 }, { 110, 342, -19 }, { 283, 449, 40 }, { 541, 521, -3 }, { 152, 186, -18 }, { 250, 218, 32 }, { 424, 326, 102 }, { 308, 144, 20 }, { 505, 275, 56 }, { 663, 367, -19 }, { 678, 446, -37 }, { 621, 193, -15 }, { 590, 96, -34 }, { 567, 167, 0 },
        },
        {
            { 102, 532, -61 }, { 55, 419, -45 }, { 304, 542, -20 }, { 265, 497, -3 }, { 136, 302, 13 }, { 516, 496, -23 }, { 484, 448, 6 }, { 186, 154, 23 }, { 389, 291, 95 }, { 465, 301, 58 }, { 353, 123, 49 }, { 550, 254, 18 }, { 694, 332, -57 }, { 714, 286, -64 }, { 648, 154, -41 }, { 641, 81, -54 },
        },
        {
            { 72, 502, -62 }, { 255, 539, -5 }, { 66, 364, -45 }, { 253, 485, 16 }, { 414, 530, 20 }, { 164, 264, 0 }, { 352, 386, 85 }, { 525, 493, 16 }, { 225, 127, -13 }, { 431, 267, 83 }, { 407, 177, 43 }, { 603, 307, 15 }, { 696, 334, -31 }, { 623, 195, -13 }, { 715, 221, -49 }, { 513, 113, -4 },
        },
        {
            { 76, 506, -47 }, { 49, 413, -34 }, { 256, 524, -1 }, { 32, 264, -31 }, { 250, 416, 46 }, { 411, 511, 5 }, { 147, 181, 11 }, { 239, 207, 56 }, { 414, 316, 78 }, { 219, 55, -13 }, { 425, 195, 53 }, { 502, 206, 25 }, { 405, 43, -10 }, { 654, 366, -44 }, { 600, 406, -24 }, { 659, 99, -70 },
        },
    };

    private static int[][] sunData = new int[][]
    {
        { 278, 244 }, { 345, 315 }, { 335, 310 }, { 328, 282 }, { 328, 279 },
        { 355, 330 }, { 344, 317 }, { 335, 312 }, { 263, 236 }, { 330, 295 },
        { 370, 335 }, { 352, 305 }, { 186, 146 }, { 326, 286 }, { 280, 241 },
        { 339, 309 }, { 348, 306 }, { 330, 311 }, { 346, 313 }, { 367, 330 },
        { 368, 344 }, { 369, 329 }, { 343, 310 }, { 367, 342 }, { 364, 325 },
        { 396, 354 }, { 285, 247 }, { 384, 335 }, { 335, 303 }, { 350, 315 },
        { 358, 328 }, { 375, 330 }, { 375, 340 }, { 350, 330 }, { 382, 331 },
        { 367, 338 }, { 375, 340 }, { 266, 227 }, { 374, 341 }, { 365, 325 },
        { 378, 334 }, { 388, 343 }, { 365, 318 }, { 326, 271 }, { 260, 221 },
        { 262, 229 }, { 337, 307 }, { 358, 330 }, { 359, 317 }, { 326, 295 },

        { 330, 310 }, { 356, 315 }, { 325, 305 }, { 350, 320 }, { 225, 173 },
        { 393, 363 }, { 370, 333 }, { 276, 233 }, { 328, 288 }, { 347, 303 },
        { 338, 295 }, { 384, 356 }, { 276, 243 }, { 334, 306 }, { 365, 328 },
        { 366, 341 }, { 361, 350 }, { 330, 283 }, { 361, 331 }, { 360, 337 },
        { 359, 315 }, { 371, 315 }, { 358, 307 }, { 367, 325 }, { 350, 310 },
        { 358, 331 }, { 248, 216 }, { 321, 306 }, { 360, 338 }, { 375, 340 },
        { 353, 327 }, { 370, 335 }, { 344, 300 }, { 370, 345 }, { 372, 331 },
        { 335, 300 }, { 380, 346 }, { 355, 325 }, { 338, 298 }, { 328, 288 },
        { 361, 339 }, { 371, 327 }, { 353, 331 }, { 365, 343 }, { 384, 336 },
        { 380, 343 }, { 372, 338 }, { 275, 228 }, { 377, 345 }, { 334, 283 },

        { 333, 310 }, { 332, 284 }, { 300, 287 }, { 320, 288 }, { 283, 243 },
        { 346, 304 }, { 324, 290 }, { 252, 231 }, { 339, 318 }, { 321, 284 },
        { 377, 361 }, { 357, 325 }, { 332, 192 }, { 355, 315 }, { 339, 305 },
        { 345, 310 }, { 375, 340 }, { 363, 317 }, { 325, 290 }, { 362, 321 },
        { 275, 238 }, { 374, 318 }, { 360, 346 }, { 377, 343 }, { 376, 344 },
        { 375, 350 }, { 360, 333 }, { 347, 299 }, { 260, 250 }, { 370, 323 },
        { 375, 330 }, { 360, 310 }, { 365, 315 }, { 338, 282 }, { 365, 330 },
        { 352, 320 }, { 330, 300 }, { 361, 337 }, { 360, 339 }, { 375, 350 },
        { 360, 346 }, { 375, 350 }, { 395, 350 }, { 356, 324 }, { 377, 328 },
        { 336, 290 }, { 390, 350 }, { 326, 307 }, { 395, 356 }, { 355, 295 }
    };

    // special cases
    private static PlanetData px_y16_3 = new PlanetData( 372, 520, -2 );
    private static PlanetData px_y17_14 = new PlanetData( 626, 132, -36 );
    private static PlanetData px_y23_9 = new PlanetData( 696, 508, -87 );
    private static PlanetData px_y23_16 = new PlanetData( 587, 187, -9 );
    private static PlanetData px_y71_16 = new PlanetData( 585, 185, -9 );

    private static Map<Flavor, Map<Position, PlanetData>> misfiledPlanets = new HashMap<>();
    private static Map<Position, Position> nexusMap = new NexusMap();
    private static Map<Position, Position> retroMap = new RetroMap();

    private static VisibilityMap visibilityMap;

    public static PlanetData getPlanetData( Flavor flavor, Position position )
    {
        // galaxy reorganization
        Position mappedPosition = mapPosition(flavor, position);
        int system = mappedPosition.getSystem();
        int planet = mappedPosition.getPlanet();

        // some planets have been misfiled
        if(misfiledPlanets.isEmpty()) {
            for(Flavor f : Flavor.values()) {
                misfiledPlanets.put(f, new HashMap<Position, PlanetData>());
                switch(f) {
                    case nexus:
                    case retro:
                    case sirius:
                        misfiledPlanets.get(f).put( new Position(1, 162, 8), new PlanetData( 400, 500, 0 ) );
                        misfiledPlanets.get(f).put( new Position(1, 272, 6), new PlanetData( 35, 100, 0 ) );
                        misfiledPlanets.get(f).put( new Position(2, 207, 16), new PlanetData( 627, 227, 20 ) );
                        misfiledPlanets.get(f).put( new Position(3, 116, 6), new PlanetData( 92, 192, 0 ) );
                        misfiledPlanets.get(f).put( new Position(3, 116, 6), new PlanetData( 92, 192, 0 ) );
                        misfiledPlanets.get(f).put( new Position(3, 197, 14), new PlanetData( 621, 193, 0 ) );
                        misfiledPlanets.get(f).put( new Position(3, 200, 14), new PlanetData( 500, 350, 0 ) );
                        misfiledPlanets.get(f).put( new Position(5, 100, 5), new PlanetData( 88, 254, 3 ) );
                        misfiledPlanets.get(f).put( new Position(5, 193, 1), new PlanetData( 66, 496, 0 ) );
                        misfiledPlanets.get(f).put( new Position(6, 100, 7), new PlanetData( 336, 370, 3 ) );
                        misfiledPlanets.get(f).put( new Position(6, 200, 2), new PlanetData( 149, 513, 0 ) );
                        misfiledPlanets.get(f).put( new Position(6, 250, 7), new PlanetData( 336, 370, 0 ) );
                        misfiledPlanets.get(f).put( new Position(7, 93, 1), new PlanetData( 44, 474, 0 ) );
                        misfiledPlanets.get(f).put( new Position(7, 222, 8), new PlanetData( 416, 384, 0 ) );
                        misfiledPlanets.get(f).put( new Position(8, 100, 7), new PlanetData( 336, 370, 0 ) );
                        misfiledPlanets.get(f).put( new Position(8, 200, 2), new PlanetData( 149, 513, 0 ) );
                        misfiledPlanets.get(f).put( new Position(8, 261, 13), new PlanetData( 485, 123, 0 ) );
                        misfiledPlanets.get(f).put( new Position(8, 261, 14), new PlanetData( 685, 257, 0 ) );
                        misfiledPlanets.get(f).put( new Position(8, 261, 15), new PlanetData( 554, 60, 0 ) );
                        misfiledPlanets.get(f).put( new Position(8 ,310, 7), new PlanetData( 346, 380, 0 ) );
                        misfiledPlanets.get(f).put( new Position(9, 99, 16), new PlanetData( 629, 69, 0 ) );
                        misfiledPlanets.get(f).put( new Position(9, 260, 10), new PlanetData( 427, 263, 0 ) );
                        misfiledPlanets.get(f).put( new Position(10, 100, 12), new PlanetData( 502, 206, 0 ) );
                        misfiledPlanets.get(f).put( new Position(10, 173, 16), new PlanetData( 650, 60, 67 ) );
                        misfiledPlanets.get(f).put( new Position(10, 260, 10), new PlanetData( 427, 263, 0 ) );
                        misfiledPlanets.get(f).put( new Position(11, 111, 7), new PlanetData( 601, 495, 0 ) );
                        break;
                    case genesis:
                        misfiledPlanets.get(f).put( new Position(1, 3, 12), new PlanetData( 519, 223, -50 ) );
                        misfiledPlanets.get(f).put( new Position(1, 162, 8), new PlanetData( 400, 500, 69 ) );
                        misfiledPlanets.get(f).put( new Position(1, 272, 6), new PlanetData( 35, 100, -21 ) );
                        misfiledPlanets.get(f).put( new Position(2, 207, 16), new PlanetData( 627, 227, 20 ) );
                        misfiledPlanets.get(f).put( new Position(3, 200, 14), new PlanetData( 500, 350, -59 ) );
                        misfiledPlanets.get(f).put( new Position(6, 200, 2), new PlanetData( 149, 513, 0 ) );
                        misfiledPlanets.get(f).put( new Position(6, 250, 7), new PlanetData( 336, 370, 0 ) );
                        misfiledPlanets.get(f).put( new Position(7, 93, 1), new PlanetData( 44, 474, 0 ) );
                        misfiledPlanets.get(f).put( new Position(7, 222, 8), new PlanetData( 416, 384, 0 ) );
                        misfiledPlanets.get(f).put( new Position(8, 100, 7), new PlanetData( 336, 370, 0 ) );
                        misfiledPlanets.get(f).put( new Position(8, 200, 2), new PlanetData( 149, 513, 0 ) );
                        misfiledPlanets.get(f).put( new Position(8, 261, 13), new PlanetData( 485, 123, 0 ) );
                        misfiledPlanets.get(f).put( new Position(8, 261, 14), new PlanetData( 685, 257, 0 ) );
                        misfiledPlanets.get(f).put( new Position(8, 261, 15), new PlanetData( 554, 60, 0 ) );
                        misfiledPlanets.get(f).put( new Position(8 ,310, 7), new PlanetData( 346, 380, 0 ) );
                        misfiledPlanets.get(f).put( new Position(9, 99, 16), new PlanetData( 629, 69, 0 ) );
                        misfiledPlanets.get(f).put( new Position(9, 206, 12), new PlanetData( 634, 458, 0 ) );
                        misfiledPlanets.get(f).put( new Position(9, 260, 10), new PlanetData( 427, 263, 0 ) );
                        misfiledPlanets.get(f).put( new Position(10, 100, 12), new PlanetData( 502, 206, 0 ) );
                        misfiledPlanets.get(f).put( new Position(10, 260, 10), new PlanetData( 427, 263, 0 ) );
                        misfiledPlanets.get(f).put( new Position(11, 111, 7), new PlanetData( 601, 495, 0 ) );
                        break;
                    default:
                        break;
                }
            }
        }
        if(misfiledPlanets.get(flavor).containsKey(mappedPosition)) {
            return misfiledPlanets.get(flavor).get(mappedPosition);
        }

        if(system == 400 && planet == 16)
        {
            system = 450;
        }

        int s = ( system - 1 ) % 150;
        int p = planet - 1;
        switch(flavor) {
            case speed:
            case solaris:
            case infinity:
                if(s == 22) {
                    switch(planet) {
                        case 9:
                            return px_y23_9;
                        case 16:
                            return px_y23_16;
                    }
                }
                else if (s== 15 && planet == 3) {
                    return px_y16_3;
                }
                else if (s== 70 && planet == 16) {
                    return px_y71_16;
                }
                break;
            case genesis:
                if (s== 16 && planet == 14 && system != 317) {
                    return px_y17_14;
                }
                break;
            default:
        }
        return new PlanetData(planetData[s][p]);
    }

    public static PlanetData getSunData( Flavor flavor, Position position )
    {
        Position mappedPosition = mapPosition(flavor, position);
        int system = mappedPosition.getSystem();

        int s = ( system - 1 ) % 150;
        return new PlanetData(sunData[s]);
    }

    private static Position mapPosition( Flavor flavor, Position position ) {
        Position rv;
        switch(flavor) {
            case nexus:
            case retro:
                Map<Position, Position> map = (flavor == Flavor.nexus) ? nexusMap : retroMap;
                Position mappedPosition = map.get(new Position(position.getGalaxy(), position.getSystem(), 0));
                // fallback for invalid positions
                if(mappedPosition == null) {
                    mappedPosition = position;
                }
                rv = new Position(mappedPosition.getGalaxy(), mappedPosition.getSystem(), position.getPlanet());
                break;
            default:
                rv = position;
        }
        return rv;
    };

    public static int getTemperature( Flavor flavor, Position position )
    {
        return getPlanetData( flavor, position ).getTemperature();
    }

    public synchronized static PositionSet getVisiblePlanets(Flavor flavor, Position system) {
        PositionSet planets;
        if(visibilityMap == null) {
            initPlanetVisibility();
        }
        PlanetVisibility planetVisibility = visibilityMap.get(flavor.name());
        if(planetVisibility != null) {
            planets = planetVisibility.getSystem(system);
        }
        else {
            planets = new PositionSet();
        }
        return planets;
    }

    private static void initPlanetVisibility() {
        try {
            visibilityMap = JSON.std.beanFrom(VisibilityMap.class, SystemData.class.getResourceAsStream("/visibility.json"));
        }
        catch(IOException e) {
            e.printStackTrace();
        }
    }
}
