/****************************************
 *  COPYRIGHT (C) 2012
 *  Holger Graf
 ****************************************/
package siarchive.components;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import siarchive.MainFrame;

/**
 * @author graf
 *
 */
public class Version
{
    private int major = 0;
    private int minor = 0;
    private int patch = 0;

    private static final String prefix = "Version";
    private static final Pattern versionPattern = Pattern.compile( prefix + "\\s+(\\d+)\\.(\\d+)\\.?(\\d*)\\s*" );

    public Version()
    {}

    public Version( int major, int minor, int patch )
    {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public int getMajor()
    {
        return major;
    }

    public void setMajor( int major )
    {
        this.major = major;
    }

    public int getMinor()
    {
        return minor;
    }

    public void setMinor( int minor )
    {
        this.minor = minor;
    }

    public int getPatch()
    {
        return patch;
    }

    public void setPatch( int patch )
    {
        this.patch = patch;
    }

    @Override
    public boolean equals( Object other )
    {
        if( ! (other instanceof Version ) ) return false;
        Version that = ( Version )other;
        return ( (this.major == that.major) && (this.minor == that.minor) && (this.patch == that.patch) );
    }

    @Override
    public int hashCode()
    {
        return (major << 20) + ( minor << 10) + patch;
    }

    public boolean matches( Version that )
    {
        if( that == null ) return false;
        return ( (this.major == that.major) && (this.minor == that.minor) );
    }

    public static Version valueOf( String value )
    {
        Matcher m = versionPattern.matcher( value );
        Version version = new Version();
        if( m.matches() )
        {
            version.setMajor( MainFrame.parseIntegerAttribute(  m.group( 1 ) ) );
            version.setMinor( MainFrame.parseIntegerAttribute(  m.group( 2 ) ) );
            version.setPatch( MainFrame.parseIntegerAttribute(  m.group( 3 ) ) );
        }
        return version;
    }

    @Override
    public String toString()
    {
        StringBuilder sb = new StringBuilder();
        sb.append( prefix );
        sb.append( ' ' );
        sb.append( toShortString() );

        return sb.toString();
    }

    public String toShortString()
    {
        StringBuilder sb = new StringBuilder();
        sb.append( major );
        sb.append( '.' );
        sb.append( pad( minor ) );
        sb.append( '.' );
        sb.append( pad( patch ) );

        return sb.toString();
    }

    private String pad( int value )
    {
        StringBuilder sb = new StringBuilder();
        if( value < 10 )
        {
            sb.append( '0' );
        }
        sb.append( value );
        return sb.toString();
    }

}
