/****************************************
 *  COPYRIGHT (C) 2008
 *  Holger Graf
 ****************************************/
package siarchive.components;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import javax.swing.JTextField;

/**
 * @author graf
 *
 */
public class TextFieldFocusListener implements FocusListener
{

    /**
     * @see java.awt.event.FocusListener#focusGained(java.awt.event.FocusEvent)
     */
    public void focusGained( FocusEvent e )
    {
        Object o = e.getSource();
        if( o instanceof JTextField )
        {
            JTextField textField = (JTextField)o;
            textField.selectAll();
        }
    }

    /**
     * @see java.awt.event.FocusListener#focusLost(java.awt.event.FocusEvent)
     */
    public void focusLost( FocusEvent e )
    {
        Object o = e.getSource();
        if( o instanceof JTextField )
        {
            JTextField textField = (JTextField)o;
            textField.select( 0, 0 );
        }
    }

}
