/****************************************
 *  COPYRIGHT (C) 2008
 *  Holger Graf
 ****************************************/
package siarchive.components;

import java.io.File;

import javax.swing.filechooser.FileFilter;

/**
 * @author graf
 *
 */
public class SiToolFileFilter extends FileFilter
{
    String description;
    String extension;

    public SiToolFileFilter( String description, String extension )
    {
        super();

        this.description = description;
        this.extension = extension;
    }

    public boolean accept( File file )
    {
        String filename = file.getName();
        return ( file.isDirectory() || filename.endsWith( extension ) );
    }

    public String getDescription()
    {
        return description;
    }
}
