/****************************************
 *  COPYRIGHT (C) 2008
 *  Holger Graf
 ****************************************/
package siarchive.components;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum Ship implements Combatant
{
    none( 0, new Cost( 0, 0, 0, 0 ), 0, 0 ),
    smallTransport( 1, new Cost( 0, 3000, 3000, 0 ), 10, 2),
    largeTransport( 2, new Cost( 0, 8000, 6000, 0 ), 25, 5),
    transmitter( 3, new Cost( 0, 25000, 25000, 0 ), 70, 130),
    smallFighter( 4, new Cost( 0, 4000, 2000, 100 ), 10, 50),
    manOWar( 5, new Cost( 0, 8000, 4000, 300 ), 30, 90),
    starCruiser( 6, new Cost( 0, 25000, 10000, 1500 ), 100, 250),
    phoenix( 7, new Cost( 0, 30000, 20000, 5000 ), 180, 320),
    colonyShip( 8, new Cost( 10000, 20000, 15000, 8000 ), 80, 10),
    solarCell( 9, new Cost( 0, 2000, 200, 400 ), 5, 0),
    probe( 10, new Cost( 0, 0, 3000, 200 ), 6, 0),
    recycler( 11, new Cost( 2000, 10000, 5000, 0 ), 30, 8),
    battleship( 13, new Cost( 0, 35000, 25000, 0 ), 300, 300),
    stealthBomber( 14, new Cost( 0, 40000, 60000, 10000 ), 100, 300),
    destroyer( 15, new Cost( 0, 60000, 50000, 2000 ), 400, 700),
    imperialStarbase( 16, new Cost( 0, 3000000, 2000000, 500000 ), 15000, 35000),
    ;

    private Cost cost;
    private int firePower;
    private int shields;
    private final String id;
    private static final Map<String, Ship> reverseMap;

    static {
        reverseMap = new HashMap<>();
        for(Ship ship : values()) {
            reverseMap.put("s" + ship.getId(), ship);
        }
    }

    public static Ship fromId(String id) {
        Ship ship = reverseMap.get(id);
        if(ship == null) {
            ship = Ship.none;
        }
        return ship;
    }


    private Ship( int id, Cost cost, int shields, int firePower)
    {
        this.cost = cost;
        this.firePower = firePower;
        this.shields = shields;
        this.id = Integer.toString(id);
    }

    public String getId() {
        return id;
    }

    /**
     * @return the cost
     */
    public Cost getCost()
    {
        return new Cost(cost);
    }

    /**
     * @return the firePower
     */
    public int getFirePower()
    {
        return firePower;
    }

    /**
     * @return the shields
     */
    public int getShields()
    {
        return shields;
    }

    public long getStructure() {
        return cost.getIron() + cost.getMetal() + cost.getKryptonite();
    }

    public static Ship[] ships() {
        return EnumSet.range( Ship.smallTransport, Ship.imperialStarbase ).toArray( new Ship[0] );
    }
}
