/****************************************
 *  COPYRIGHT (C) 2010-2021
 *  Holger Graf
 ****************************************/
package siarchive.components;

/**
 * @author graf
 *
 */
public enum SearchOption
{
    alliances,
    attacker,
    defender,
    planets,
    players,
    points,
    priority,
    systems,
    time,
    attackstatus,
    level,
    ;

    public static SearchOption[] forPlanets()
    {
        return new SearchOption[] {
            SearchOption.alliances, SearchOption.planets, SearchOption.players, SearchOption.points, SearchOption.systems
        };
    }

    public static SearchOption[] forBattleReports()
    {
        return new SearchOption[] {
            SearchOption.attacker, SearchOption.defender, SearchOption.systems, SearchOption.time
        };
    }

    public static SearchOption[] forSpyReports()
    {
        return new SearchOption[] {
            SearchOption.planets, SearchOption.players, SearchOption.systems, SearchOption.time
        };
    }

    public static SearchOption[] forBlackHoles()
    {
        return new SearchOption[] {
            SearchOption.level, SearchOption.attackstatus, SearchOption.systems
        };
    }

}
