/****************************************
 *  COPYRIGHT (C) 2008
 *  Holger Graf
 ****************************************/
package siarchive.components;

import java.util.HashMap;
import java.util.Map;

import javax.swing.Icon;

import siarchive.DataManager;

public enum Research
{
    mining( 1, new Cost( 1000, 0, 500, 0 ) ),
    energytech( 2, new Cost( 0, 400, 800, 400 ) ),
    drive( 3, new Cost( 0, 800, 0, 250 ) ),
    rocket( 4, new Cost( 0, 400, 350, 100 ) ),
    diffusion( 5, new Cost( 0, 300, 300, 200 ) ),
    warp( 6, new Cost( 0, 5000, 2000, 1000 ) ),
    espionage( 7, new Cost( 0, 500, 2000, 300 ) ),
    weapons( 8, new Cost( 0, 2000, 100, 0 ) ),
    shields( 9, new Cost( 0, 250, 2000, 0 ) ),
    structure( 10, new Cost( 0, 2500, 0, 0 ) ),
    target( 11, new Cost( 0, 1000, 2000, 500 ) ),
    particle( 12, new Cost( 0, 5000, 8000, 10000 ) ),
    graviton( 13, new Cost( 0, 300, 2000, 300 ) ),
    teleportation( 14, new Cost( 0, 100000, 80000, 20000 ) ),
    blackhole( 15, new Cost( 0, 500000, 1000000, 250000 ) ),
    ;

    private final Cost cost;
    private final String id;
    private static final Map<String, Research> reverseMap;

    static {
        reverseMap = new HashMap<>();
        for(Research research : values()) {
            reverseMap.put("r" + research.getId(), research);
        }
    }

    public static Research fromId(String id) {
        return reverseMap.get(id);
    }


    private Research( final int id, final Cost cost )
    {
        this.cost = cost;
        this.id = Integer.toString(id);
    }

    public String getId() {
        return id;
    }

    public Cost getCost()
    {
        return cost;
    }

    public Icon getIcon()
    {
        Icon rv = DataManager.getIcon( "/research_" + getId() + ".gif" );
        return rv;
    }
}
