/****************************************
 *  COPYRIGHT (C) 2010
 *  Holger Graf
 ****************************************/
package siarchive.components;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;


public class PositionField extends JComponent
{
    private static final long serialVersionUID = 7486663925998614807L;
    private JSpinner galaxyField = new JSpinner();
    private JSpinner systemField = new JSpinner();
    private JSpinner planetField = new JSpinner();

    public PositionField()
    {
        this( true );
    }

    public PositionField( boolean showPlanet )
    {
        super();
        super.setLayout( new GridBagLayout() );

        galaxyField.setModel( new SpinnerNumberModel( 1, 1, 14, 1 ) );
        systemField.setModel( new SpinnerNumberModel( 1, 1, 400, 1 ) );
        planetField.setModel( new SpinnerNumberModel( 1, 1, 16, 1 ) );

        // initialize constraints
        GridBagConstraints fieldConstraints = new GridBagConstraints();
        fieldConstraints.gridheight = 1;
        fieldConstraints.gridwidth = 1;
        fieldConstraints.fill = GridBagConstraints.BOTH;
        fieldConstraints.anchor = GridBagConstraints.CENTER;
        fieldConstraints.weighty = 1.0;

        fieldConstraints.weightx = 1.0;
        add( galaxyField, fieldConstraints );
        fieldConstraints.weightx = 0.0;
        add( new JLabel( ":" ), fieldConstraints );
        fieldConstraints.weightx = 1.0;
        add( systemField, fieldConstraints );
        fieldConstraints.weightx = 0.0;
        if( showPlanet )
        {
            add( new JLabel( ":" ), fieldConstraints );
            fieldConstraints.weightx = 1.0;
            add( planetField, fieldConstraints );
        }

        FocusListener l = new TextFieldFocusListener();
        galaxyField.addFocusListener( l );
        systemField.addFocusListener( l );
        planetField.addFocusListener( l );
    }

    public Position getPosition()
    {
        int galaxy = getFieldvalue(galaxyField);
        int system = getFieldvalue(systemField);
        int planet = getFieldvalue(planetField);

        return new Position( galaxy, system, planet );
    }

    public Position getPosition( int planet )
    {
        int galaxy = getFieldvalue(galaxyField);
        int system = getFieldvalue(systemField);

        return new Position( galaxy, system, planet );
    }

    public void setPosition( Position position )
    {
        galaxyField.setValue( Integer.valueOf( position.getGalaxy() ) );
        systemField.setValue( Integer.valueOf( position.getSystem() ) );
        planetField.setValue( Integer.valueOf( position.getPlanet() ) );
    }

    public void setMinGalaxies(int min) {
        SpinnerNumberModel model = (SpinnerNumberModel)galaxyField.getModel();
        int value = ((Number)model.getValue()).intValue();
        model.setMinimum(Integer.valueOf(min));
        if(value < min) {
            model.setValue(Integer.valueOf(min));
        }
    }

    public void setMaxGalaxies(int max) {
        SpinnerNumberModel model = (SpinnerNumberModel)galaxyField.getModel();
        int value = ((Number)model.getValue()).intValue();
        model.setMaximum(Integer.valueOf(max));
        if(value > max) {
            model.setValue(Integer.valueOf(max));
        }
    }

    public void setMinSystems(int min) {
        SpinnerNumberModel model = (SpinnerNumberModel)systemField.getModel();
        int value = ((Number)model.getValue()).intValue();
        model.setMinimum(Integer.valueOf(min));
        if(value < min) {
            model.setValue(Integer.valueOf(min));
        }
    }

    public void setMaxSystems(int max) {
        SpinnerNumberModel model = (SpinnerNumberModel)systemField.getModel();
        int value = ((Number)model.getValue()).intValue();
        model.setMaximum(Integer.valueOf(max));
        if(value > max) {
            model.setValue(Integer.valueOf(max));
        }
    }

    public void addChangeListener( ChangeListener l )
    {
        galaxyField.addChangeListener( l );
        systemField.addChangeListener( l );
        planetField.addChangeListener( l );
    }

    public void removeChangeListener( ChangeListener l )
    {
        galaxyField.removeChangeListener( l );
        systemField.removeChangeListener( l );
        planetField.removeChangeListener( l );
    }

    public void addFocusListener( FocusListener l )
    {
        galaxyField.addFocusListener( l );
        systemField.addFocusListener( l );
        planetField.addFocusListener( l );
    }

    public void removeFocusListener( FocusListener l )
    {
        galaxyField.removeFocusListener( l );
        systemField.removeFocusListener( l );
        planetField.removeFocusListener( l );
    }

    private int getFieldvalue( JSpinner field )
    {
        int rv = 0;
        Object value = field.getValue();
        if( value instanceof Number )
        {
            rv = ((Number)value).intValue();
        }
        return rv;
    }
}
