/****************************************
 *  COPYRIGHT (C) 2010
 *  Holger Graf
 ****************************************/
package siarchive.components;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

import siarchive.persistence.Planet;


/**
 * @author graf
 *
 */
public class PlanetarySystem
{
    private int position;
    private long time = 0;
    private long highTime = 0;
    private Set<Planet> planets = new HashSet<Planet>();

    public PlanetarySystem()
    {}

    /**
     * @param account
     * @param position
     */
    public PlanetarySystem( int position, Collection<Planet> planets)
    {
        this.position = position;
        this.setPlanets( planets );
    }


    public int getPosition()
    {
        return position;
    }

    public long getTime()
    {
        return time;
    }

    public long getHighTime()
    {
        return highTime;
    }

    public boolean isValidTime()
    {
    	return ( planets.size() > 0 && getTime() != 0 );
    }
    
    public Collection<Planet> getPlanets()
    {
        return planets;
    }
    
    private void setPlanets(Collection<Planet> planets)
    {
        if(planets != null)
        {
            this.planets.clear();
            Set<Long> timeSet = new TreeSet<Long>(); 
            for(Planet planet : planets)
            {
                this.planets.add( planet );
                timeSet.add( planet.getUpdateTime() );
            }
            int size = timeSet.size();
            if(size > 0)
            {
                Long[] times = timeSet.toArray( new Long[size] );
                time = times[0];
                highTime = times[size - 1];
            }
        }
    }
    
    public static int calculatePosition( int position )
    {
        // remove the planet part
        return ( position / 100 ) * 100;
    }

    @Override
    public int hashCode()
    {
        final int prime = 31;
        int result = prime * position;
        return result;
    }

    @Override
    public boolean equals( Object obj )
    {
        if( this == obj )
            return true;
        if( obj == null )
            return false;
        if( getClass() != obj.getClass() )
            return false;
        PlanetarySystem other = ( PlanetarySystem )obj;
        if( position != other.position )
            return false;
        return true;
    }

}
