/****************************************
 *  COPYRIGHT (C) 2010-2024
 *  Holger Graf
 ****************************************/
package siarchive.components;

import javax.swing.UIManager;

/**
 * @author graf
 *
 */
public enum LaFStyle
{
    defaultLaF( "Default", 'd', Family.system, UIManager.getSystemLookAndFeelClassName() ),
    nimbus( "Nimbus", 'i', Family.nimbus, "javax.swing.plaf.nimbus.NimbusLookAndFeel" ),
    black( "Black", 'b', Family.substance, "org.pushingpixels.substance.api.skin.SubstanceOfficeBlack2007LookAndFeel" ),
    blacksteel( "Black Steel", 'a', Family.substance, "org.pushingpixels.substance.api.skin.SubstanceBusinessBlackSteelLookAndFeel" ),
    blue( "Blue", 'l', Family.substance, "org.pushingpixels.substance.api.skin.SubstanceOfficeBlue2007LookAndFeel" ),
    bluesteel( "Blue Steel", 'u', Family.substance, "org.pushingpixels.substance.api.skin.SubstanceBusinessBlueSteelLookAndFeel" ),
    challenger( "Challenger", 'c', Family.substance, "org.pushingpixels.substance.api.skin.SubstanceChallengerDeepLookAndFeel" ),
    creme( "Creme", 'm', Family.substance, "org.pushingpixels.substance.api.skin.SubstanceCremeLookAndFeel" ),
    dust( "Dust", 't', Family.substance, "org.pushingpixels.substance.api.skin.SubstanceDustLookAndFeel" ),
    emerald( "Emerald", 'e', Family.substance, "org.pushingpixels.substance.api.skin.SubstanceEmeraldDuskLookAndFeel" ),
    graphite( "Graphite", 'g', Family.substance, "org.pushingpixels.substance.api.skin.SubstanceGraphiteLookAndFeel" ),
    nebula( "Nebula", 'n', Family.substance, "org.pushingpixels.substance.api.skin.SubstanceNebulaLookAndFeel" ),
    raven( "Raven", 'r', Family.substance, "org.pushingpixels.substance.api.skin.SubstanceRavenLookAndFeel" ),
    sahara( "Sahara", 'h', Family.substance, "org.pushingpixels.substance.api.skin.SubstanceSaharaLookAndFeel" ),
    silver( "Silver", 's', Family.substance, "org.pushingpixels.substance.api.skin.SubstanceOfficeSilver2007LookAndFeel" ),
    ;

    private final String className;
    private final char mnemonic;
    private final Family family;
    private final String name;

    private LaFStyle( final String name, char mnemonic, final Family family, final String className )
    {
        this.name = name;
        this.mnemonic = mnemonic;
        this.family = family;
        this.className = className;
    }

    public String getClassName()
    {
        return className;
    }

    public char getMnemonic() {
        return mnemonic;
    }

    public Family getFamily() {
        return family;
    }

    public String getName() {
        return name;
    }

    public static enum Family {
        nimbus,
        system,
        substance
    }
}
