/****************************************
 *  COPYRIGHT (C) 2020-2025
 *  Holger Graf
 ****************************************/
package siarchive.components;

/**
 * @author graf
 *
 */
public enum Flavor
{
    nexus(44, 8, 400, 14, false), retro(31, 8, 400, 14, false), sirius(46, 6, 400, 14, true), genesis(40, 4, 400, 14, true),
    speed(35, 8, 400, 14, false), solaris(45, 6, 200, 14, true), infinity(47, 5, 400, 14, true);

    private final int upperGalaxyBound;
    private final int upperSystemBound;
    private final int id;
    private final int outpostGalaxy;
    private final boolean hasMissingPlanets;

    private Flavor(final int id, final int upperGalaxyBound, final int upperSystemBound,
                   final int outpostGalaxy, final boolean hasMissingPlanets) {
        this.id = id;
        this.upperGalaxyBound = upperGalaxyBound;
        this.upperSystemBound = upperSystemBound;
        this.outpostGalaxy = outpostGalaxy;
        this.hasMissingPlanets = hasMissingPlanets;
    }

    public static Flavor fromId(int flavorId) {
        // this makes the beta test look like sirius
        flavorId %= 855;
        Flavor result = null;
        for(Flavor flavor : values()) {
            if(flavorId == flavor.getId()) {
                result = flavor;
                break;
            }
        }
        if(result == null) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public int getId() {
        return id;
    }

    public int getUpperGalaxyBound() {
        return upperGalaxyBound;
    }

    public int getUpperSystemBound() {
        return upperSystemBound;
    }

    public int getOutpostGalaxy() {
        return outpostGalaxy;
    }

    public boolean hasMissingPlanets() {
        return hasMissingPlanets;
    }
}
