/****************************************
 *  COPYRIGHT (C) 2008
 *  Holger Graf
 ****************************************/
package siarchive.components;

import siarchive.DataManager;

/**
 * Wraps an Enum in an i18n aware container suitable for e.g. Combo Boxes
 * @author graf
 */
public class EnumWrapper<E extends Enum<E>>
{
    private E base;
    private DataManager configData;
    
    public EnumWrapper( DataManager configData, E base )
    {
        this.base = base;
        this.configData = configData;
    }

    public E getBase()
    {
        return base;
    }

    @SuppressWarnings("unchecked")
	@Override
	public boolean equals(Object obj) 
    {
    	boolean rv = false;
		if( obj instanceof EnumWrapper )
		{
			rv = ( base == ((EnumWrapper<E>)obj).base );
		}
		return rv;
	}

	@Override
    public String toString()
    {
        return configData.getI18nText( base.name() );
    }
}
