/****************************************
 *  COPYRIGHT (C) 2018
 *  Holger Graf
 ****************************************/
package siarchive.components;

import java.util.HashMap;
import java.util.Map;


public enum Defense implements Combatant
{
    mortar( 1, new Cost( 0, 2000, 0, 0 ), 15, 35 ),
    turboFlak( 2, new Cost( 0, 10000, 2000, 0 ), 80, 220 ),
    gravitonCannon( 3, new Cost( 0, 2000, 1000, 0 ), 25, 50 ),
    heavyGravitonCannon( 4, new Cost( 0, 5000, 2000, 0 ), 60, 115 ),
    ionGun( 5, new Cost( 0, 2000, 8000, 0 ), 125, 125 ),
    positronLighter( 6, new Cost( 0, 10000, 30000, 100 ), 200, 700 ),
    intervalCannon( 7, new Cost( 0, 15000, 15000, 1500 ), 100, 900 ),
    laserBattery( 8, new Cost( 0, 20000, 20000, 500 ), 400, 1000 ),
    solarGun( 9, new Cost( 0, 40000, 80000, 8000 ), 1000, 2000 ),
    smallShieldDome( 10, new Cost( 0, 8000, 5000, 3000 ), 3000, 0),
    largeShieldDome( 11, new Cost( 0, 25000, 15000, 8000 ), 30000, 0 ),
    ;

    private final  Cost cost;
    private final int firePower;
    private final int shields;
    private final String id;
    private static final Map<String, Defense> reverseMap;

    static {
        reverseMap = new HashMap<>();
        for(Defense defense : values()) {
            reverseMap.put("d" + defense.getId(), defense);
        }
    }

    public static Defense fromId(String id) {
        Defense defense = reverseMap.get(id);
        return defense;
    }

    private Defense( final int id, Cost cost, int shields, int firePower )
    {
        this.cost = cost;
        this.firePower = firePower;
        this.shields = shields;
        this.id = Integer.toString(id);
    }

    public String getId() {
        return id;
    }

    /**
     * @return the cost
     */
    public Cost getCost()
    {
        return cost;
    }

    /**
     * @return the firePower
     */
    public int getFirePower()
    {
        return firePower;
    }

    /**
     * @return the shields
     */
    public int getShields()
    {
        return shields;
    }

    public long getStructure() {
        return cost.getIron() + cost.getMetal() + cost.getKryptonite();
    }
}
