package siarchive.components;

import java.util.Calendar;
import java.util.Date;

import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;


public class DateTimeField extends JSpinner
{
	private static final long serialVersionUID = -2097477418497166918L;

	private static final long max = 5 * 24 * 3600 * 1000;
	private SpinnerDateModel model;

	public DateTimeField()
	{
		super();

        long now = System.currentTimeMillis();
        model = new SpinnerDateModel( new Date(now), new Date( 0L ), new Date( now + max ), Calendar.HOUR_OF_DAY );
        
        setModel( model );
        setEditor(new JSpinner.DateEditor( this, "HH:mm dd.MM.yyyy" ) );
	}

	public Date getDate()
	{
        return (Date) model.getValue();
	}
}
