/****************************************
 *  COPYRIGHT (C) 2008
 *  Holger Graf
 ****************************************/
package siarchive.components;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

import javax.swing.Icon;

import siarchive.DataManager;

public enum Building
{
    ironMine( 1, new Cost( 78, 0, 25, 0 ) ),
    furnace( 2, new Cost( 75, 0, 25, 0 ) ),
    kryptoniteMine( 3, new Cost( 90, 0, 55, 0 ) ),
    spiceMine( 4, new Cost( 0, 220, 80, 0 ) ),
    fusionPlant( 5, new Cost( 80, 0, 35, 0 ) ),
    thermosolarPlant( 6, new Cost( 0, 120, 25, 80 ) ),
    developmentCenter( 7, new Cost( 0, 600, 300, 200 ) ),
    researchLab( 8, new Cost( 0, 800, 0, 300 ) ),
    weaponsFactory( 9, new Cost( 300, 200, 0, 350 ) ),
    fleetBase( 10, new Cost( 0, 2000, 500, 800 ) ),
    ironStorage( 11, new Cost( 2000, 800, 0, 0 ) ),
    metalStorage( 12, new Cost( 2000, 800, 0, 0 ) ),
    kryptoniteStorage( 13, new Cost( 2000, 800, 0, 0 ) ),
    spiceStorage( 14, new Cost( 2000, 800, 0, 0 ) ),
    particleCannon( 15, new Cost( 50000, 30000, 40000, 6000 ) ),
    particleShield( 16, new Cost( 15000, 10000, 12000, 5000 ) ),
    msa( 17, new Cost( 0, 500000, 1000000, 250000 ) ),
    teleporter( 18, new Cost( 100000, 140000, 150000, 50000 ) ),
    scanner( 19, new Cost( 10000, 40000, 20000, 8000 ) )
    ;

    private final Cost cost;
    private final String id;
    private static final Map<String, Building> reverseMap;

    static {
        reverseMap = new HashMap<>();
        for(Building building : values()) {
            reverseMap.put("b" + building.getId(), building);
        }
    }

    public static Building fromId(String id) {
        return reverseMap.get(id);
    }


    private Building( final int id, final Cost cost )
    {
        this.id = Integer.toString(id);
        this.cost = cost;
    }

    public String getId() {
        return id;
    }

    public Cost getCost()
    {
        return cost;
    }

    public static Building[] planetBuildings()
    {
        return EnumSet.range( Building.ironMine, Building.teleporter ).toArray( new Building[0] );
    }

    public static Building[] astroBuildings()
    {
        return EnumSet.of( Building.developmentCenter, Building.weaponsFactory,
                            Building.fleetBase, Building.msa, Building.scanner ).toArray( new Building[0] );
    }

    public Icon getIcon()
    {
        Icon icon = DataManager.getIcon( "/building_" + getId() + ".gif" );
        return icon;
    }

}
