/****************************************
 *  COPYRIGHT (C) 2021
 *  Holger Graf
 ****************************************/
package siarchive.components;

/**
 * @author graf
 *
 */
public enum BlackHoleLevel {
    all(null),
    white(Integer.valueOf(0)),
    green(Integer.valueOf(1)),
    blue(Integer.valueOf(2)),
    red(Integer.valueOf(3)),
    boss(Integer.valueOf(10)),
    ;

    private Integer level;

    private BlackHoleLevel(Integer level) {
        this.level = level;
    }

    public Integer getLevel() {
        return level;
    }

    public static BlackHoleLevel fromLevel(Integer level) {
        if(level == null) {
            return all;
        }
        BlackHoleLevel rv = null;
        switch(level) {
            case 0:
                rv = white;
                break;
            case 1:
                rv = green;
                break;
            case 2:
                rv = blue;
                break;
            case 3:
                rv = red;
                break;
            case 10:
                rv = boss;
                break;
        }
        if(rv == null) {
            throw new IllegalArgumentException("No such BlackHoleLevel: "+ level);
        }
        return rv;
    }
}
