/****************************************
 *  COPYRIGHT (C) 2010-2021
 *  Holger Graf
 ****************************************/
package siarchive;

import java.awt.Dimension;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import javax.swing.ImageIcon;

import siarchive.components.Position;

/**
 * @author graf
 *
 */
public class Resources
{
    private static Map<String, ImageIcon> resources = new HashMap<String, ImageIcon>();

    static
    {
        addResource( "/battle.png" );
        addResource( "/blackhole0.png" );
        addResource( "/blackhole1.png" );
        addResource( "/blackhole2.png" );
        addResource( "/blackhole3.png" );
        addResource( "/blackhole4.png" );
        addResource( "/blackhole10.png" );
        Dimension size = new Dimension(32, 16);
        addResource( "/blackhole0.png.resized", size );
        addResource( "/blackhole1.png.resized", size );
        addResource( "/blackhole2.png.resized", size );
        addResource( "/blackhole3.png.resized", size );
        addResource( "/blackhole4.png.resized", size );
        addResource( "/blackhole10.png.resized", size );
        addResource( "/bubble-high.png" );
        addResource( "/bubble-low.png" );
        addResource( "/bubble-normal.png" );
        addResource( "/close.png" );
        addResource( "/connection-off.png" );
        addResource( "/connection-on.png" );
        addResource( "/db-on.png" );
        addResource( "/db-off.png" );
        addResource( "/debris.png" );
        addResource( "/fleet.png" );

        for( int galaxy = 1; galaxy <= 14; galaxy++ )
        {
            StringBuilder path = new StringBuilder();
            path.append( "/galaxy" );
            if( galaxy < 10 )
            {
                path.append( '0' );

            }
            path.append( galaxy );
            path.append( ".jpg" );
            addResource( path.toString() );
        }

        addResource( "/gold.png" );
        addResource( "/moon.png", 13 );
        addResource( "/notes.png" );
        addResource( "/notes-off.png" );
        addResource( "/notes-small.png" );
        addResource( "/peace.png" );
        addResource( "/planet_event.png" );

        for( int planet = Position.lowerPlanetBound; planet <= Position.upperPlanetBound; planet++ )
        {
            StringBuilder path = new StringBuilder();
            path.append( "/planet" );
            if( planet < 10 )
            {
                path.append( '0' );

            }
            path.append( planet );
            path.append( ".png" );
            addResource( path.toString(), 25 );
        }

        addResource( "/scroll.png" );
        addResource( "/silver.png" );
        addResource( "/sun.png" );
        addResource( "/swords.png" );
        addResource( "/symbol.png" );
    }

    public static ImageIcon getIcon( String path )
    {
        return resources.get( path );
    }

    private static void addResource( String path )
    {
        resources.put( path, createIcon( path ) );
    }

    private static void addResource( String path, Dimension size ) {
        resources.put( path, createIcon( path.replace(".resized", ""), size ) );
    }

    private static void addResource( String path, int scale ) {
        resources.put( path, createIcon( path, scale ) );
    }

    private static ImageIcon createIcon( String path ) {
        ImageIcon rv = null;
        URL url = null;
        try {
            url = Resources.class.getResource( path );
        }
        catch( Exception ex )
        {}
        if( url != null ) {
            rv = new ImageIcon( url, path );
        }
        return rv;
    }

    private static ImageIcon createIcon(String path, Dimension size) {
        ImageIcon imageIcon = getIcon(path);
        if(imageIcon != null && size != null) {
            imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(size.width, size.height,  java.awt.Image.SCALE_SMOOTH));
        }
        return imageIcon;
    }

    private static ImageIcon createIcon(String path, int scale) {
        ImageIcon imageIcon = createIcon(path);
        if(imageIcon != null) {
            Dimension size = new Dimension(scale * imageIcon.getIconWidth() / 100, scale * imageIcon.getIconHeight() / 100);
            imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(size.width, size.height,  java.awt.Image.SCALE_SMOOTH));
        }
        return imageIcon;
    }

}
