/****************************************
 *  COPYRIGHT (C) 2008, 2024
 *  Holger Graf
 ****************************************/
package siarchive;

import java.io.InputStream;
import java.io.OutputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;

public class Parser
{
    DocumentBuilder builder = null;

    public final static String Tag_Application = "SiArchive";
    public final static String Tag_Account = "Account";
    public final static String Tag_Alliance = "Alliance";
    public final static String Tag_BattleReport = "BattleReport";
    public final static String Tag_BlackHole = "BlackHole";
    public final static String Tag_Planet = "Planet";
    public final static String Tag_Player = "Player";
    public final static String Tag_Ships = "Ships";
    public final static String Tag_SpyReport = "SpyReport";

    public final static String Attribute_Attacker = "attacker";
    public final static String Attribute_Attacked = "attacked";
    public final static String Attribute_Alliance = "alliance";
    public final static String Attribute_Alliance_Id = "allianceId";
    public final static String Attribute_Data = "data";
    public final static String Attribute_Debris = "debris";
    public final static String Attribute_Default = "default";
    public final static String Attribute_Defender = "defender";
    public final static String Attribute_Emblems = "emblems";
    public final static String Attribute_Flavor = "flavor";
    public final static String Attribute_Id = "id";
    public final static String Attribute_isAsteroid = "isAsteroid";
    public final static String Attribute_isEvent = "isEvent";
    public final static String Attribute_Language = "language";
    public final static String Attribute_Level = "level";
    public final static String Attribute_Name = "name";
    public final static String Attribute_Notes = "notes";
    public final static String Attribute_Outpost = "outpost";
    public final static String Attribute_Owner = "owner";
    public final static String Attribute_Owner_Id = "ownerId";
    public final static String Attribute_Points = "points";
    public final static String Attribute_Position = "position";
    public final static String Attribute_Power = "power";
    public final static String Attribute_Priority = "priority";
    public final static String Attribute_Setup = "setup";
    public final static String Attribute_Specialization = "specialization";
    public final static String Attribute_SpiceValue = "spiceValue";
    public final static String Attribute_Stars = "stars";
    public final static String Attribute_Status = "status";
    public final static String Attribute_Secondary_Status = "secondaryStatus";
    public final static String Attribute_Tag = "tag";
    public final static String Attribute_Time = "time";
    public final static String Attribute_Title = "title";
    public final static String Attribute_Upgrade = "upgrade";
    public final static String Attribute_Version = "version";

    /****************************************
     * Constructor for the Parser object
     *
     * @throws ParserConfigurationException  Description of the Exception
     ***************************************/
    public Parser() throws ParserConfigurationException
    {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating( false );
        factory.setIgnoringElementContentWhitespace( true );
        builder = factory.newDocumentBuilder();
    }


    /****************************************
     * Gets the document attribute of the Parser object
     *
     * @param is  Description of the Parameter
     * @return    The document value
     ***************************************/
    public Document getDocument( InputStream is )
    {
        Document doc = null;
        try
        {
            doc = builder.parse( is );
        }
        catch ( Exception ex )
        {
            ex.printStackTrace();
        }

        return doc;
    }


    /****************************************
     * Gets the document attribute of the Parser object
     *
     * @return   The document value
     ***************************************/
    public Document getDocument()
    {
        Document doc = null;
        doc = builder.newDocument();
        return doc;
    }

    public void writeDocument( OutputStream os, Document doc )
    {
        try
        {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer;
            transformer = tFactory.newTransformer();
            transformer.setOutputProperty( "indent", "yes" );
            transformer.setOutputProperty( "method", "xml" );

            DOMSource source = new DOMSource( doc );
            StreamResult result = new StreamResult( os );
            transformer.transform( source, result );
        }
		catch (TransformerConfigurationException e)
		{
			//e.printStackTrace();
		}
		catch (TransformerException e)
		{
			//e.printStackTrace();
		}
    }
}
