/****************************************
 *  COPYRIGHT (C) 2008
 *  Holger Graf
 ****************************************/
package siarchive;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EtchedBorder;

/**
 * 
 * @author graf
 *
 */
public class HelpBox extends JDialog implements ActionListener
{
	private static final long serialVersionUID = -6918847577994907058L;
	private DataManager configData;
	
	public HelpBox( MainFrame parent )
    {
        super( parent );
        configData = parent.getDataManager();
        enableEvents( AWTEvent.WINDOW_EVENT_MASK );
        this.setTitle( configData.getI18nText( "Help.title", "SI-Archive" ) );
        JPanel contentPane = ( JPanel )getContentPane();
        contentPane.setLayout( new BorderLayout() );
        contentPane.setBorder( BorderFactory.createEtchedBorder( EtchedBorder.LOWERED ) );
        
        JPanel center = createCenterPanel();
        center.setPreferredSize( new Dimension( 640, 520 ) );
        
        JPanel lower = new JPanel( new FlowLayout( FlowLayout.CENTER, 4, 4 ) );
        JButton button = new JButton( configData.getI18nText( "OK" ) );
        button.addActionListener( this );
        lower.add( button );
        getRootPane().setDefaultButton( button );
        
        contentPane.add( center, BorderLayout.CENTER );
        contentPane.add( lower, BorderLayout.SOUTH );
        pack();
    }

    protected JPanel createCenterPanel()
    {
        JPanel center = new JPanel( new GridLayout() );
        center.setBorder( BorderFactory.createEmptyBorder( 5, 10, 5, 10) );
        JTextPane textPane = new JTextPane();
        try 
        {
			textPane.setPage( getClass().getResource( configData.getI18nText( "Help.url" ) ) );
		} 
        catch (IOException e) 
		{}
        
        JScrollPane scrollPane;
        scrollPane = new JScrollPane( textPane, 
                        JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                        JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED );
        center.add( scrollPane );
        return center;
    }
    
    // Overridden so we can exit when window is closed
    /***************************************************************************
     * Description of the Method
     * @param e Description of the Parameter
     **************************************************************************/
    protected void processWindowEvent( WindowEvent e )
    {
        if( e.getID() == WindowEvent.WINDOW_CLOSING )
        {
            cancel();
        }
        super.processWindowEvent( e );
    }

    // Close the dialog

    /***************************************************************************
     * Description of the Method
     **************************************************************************/
    void cancel()
    {
        dispose();
    }

    // Close the dialog on a button event

    /***************************************************************************
     * Description of the Method
     * @param e Description of the Parameter
     **************************************************************************/
    public void actionPerformed( ActionEvent e )
    {
        cancel();
    }
}
