/****************************************
 *  COPYRIGHT (C) 2008-2024
 *  Holger Graf
 ****************************************/
package siarchive;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;

import siarchive.components.Version;

/**
 *
 * @author graf
 *
 */
public class AboutBox extends JDialog implements ActionListener
{
    private static final long serialVersionUID = 9141620080105019507L;
    protected static final int GPL = 1;
    protected static final int APACHE = 2;
    protected static final int BSD = 3;
    protected static final int SUBSTANCE = 4;

    private static final char copyright = '\u00a9';

    private static final String identifier = "siarchive";
    private static final String productName = "SI Archive";
    private static final Version version = new Version( 3, 4, 4 );
    private static final String copyright1 = "Copyright "+ copyright + " 2012-2024 by Holger Graf";
    private static final String copyright2 = "Substance Copyright "+ copyright + " 2005-2010, Kirill Grouchnikov and contributors";
    private static final String comment1 = "This software is released under the GNU GPL.";
    private static final String comment2 = "This software may not be used commercially and there is NO WARRANTY of any kind attached to it.";
    private static final String comment3 = "SI-Archive contains JLHTTP and uses Apache Commons Lang, ";
    private static final String comment4 = "Jackson core and Jackson Jr. JSON libraries,";
    private static final String comment5 = "Postgres JDBC driver and xerial/sqlite-jdbc.";
    private static final String comment6 = "This software contains the Substance look and feel";
    private static final String comment7 = "from https://substance.dev.java.net/ under the license below.";
    private static final String comment8 = "<html>Exoplanets copyright " + copyright
                                         + " <a href=\"https://www.esa.int/ESA_Multimedia/Images/2022/04/Hubble_observations_used_to_answer_key_exoplanet_questions\"> ESA/Hubble, N. Bartmann; CC BY 4.0</a>.</html>";
    private static final String comment9 = "For further information see the License Tabs below.";

    public AboutBox( Frame parent )
    {
        super( parent );
        enableEvents( AWTEvent.WINDOW_EVENT_MASK );
        this.setTitle( "About" );
        JPanel contentPane = ( JPanel )getContentPane();
        contentPane.setLayout( new BorderLayout() );
        contentPane.setBorder( BorderFactory.createEtchedBorder( EtchedBorder.LOWERED ) );
        JPanel upper = new JPanel( new FlowLayout( FlowLayout.LEADING, 50, 5 ) );
        JLabel imageLabel = new JLabel();
        imageLabel.setBorder( BorderFactory.createEmptyBorder( 0, 10, 0, 20 ) );
        imageLabel.setIcon( new ImageIcon( AboutBox.class.getResource( "/help.png" ) ) );
        upper.add( imageLabel );
        JPanel right = new JPanel( new GridLayout( 17, 1 ) );
        right.add( new JLabel( productName ) );
        right.add( new JLabel( version.toString() ) );
        right.add( new JLabel( copyright1 ) );
        right.add( new JLabel( copyright2 ) );
        JLabel contact = new JLabel( "Contact:" );
        contact.setHorizontalTextPosition( JLabel.LEFT );
        contact.setIcon( new ImageIcon( AboutBox.class.getResource( "/contact.gif" ) ) );
        right.add( contact );
        right.add( new JLabel() );
        right.add( new JLabel( comment1 ) );
        right.add( new JLabel( comment2 ) );
        right.add( new JLabel() );
        right.add( new JLabel( comment3 ) );
        right.add( new JLabel( comment4 ) );
        right.add( new JLabel( comment5 ) );
        right.add( new JLabel( comment6 ) );
        right.add( new JLabel( comment7 ) );
        right.add( new JLabel() );
        JLabel huggle = new JLabel( comment8 );
        right.add( huggle );
        right.add( new JLabel( comment9 ) );
        upper.add( right );

        huggle.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked( MouseEvent e ) {
                try {
                    Desktop.getDesktop().browse(new URI("https://www.esa.int/ESA_Multimedia/Images/2022/04/Hubble_observations_used_to_answer_key_exoplanet_questions"));
                  } catch (IOException | URISyntaxException ex) {}
            }
        });

        JPanel center = createCenterPanel();
        Dimension dim = center.getPreferredSize();
        //dim.width -= 70;
        dim.height = 350;
        center.setPreferredSize( dim );

        JPanel lower = new JPanel( new FlowLayout( FlowLayout.CENTER, 4, 4 ) );
        JButton button = new JButton( "Ok" );
        button.addActionListener( this );
        lower.add( button );
        getRootPane().setDefaultButton( button );

        contentPane.add( upper, BorderLayout.NORTH );
        contentPane.add( center, BorderLayout.CENTER );
        contentPane.add( lower, BorderLayout.SOUTH );
        pack();
    }

    public static String getIdentifier()
    {
        return identifier;
    }

    public static String getProductName()
    {
        return productName;
    }

    public static Version getVersion()
    {
        return version;
    }

    protected JPanel createCenterPanel()
    {
        JPanel center = new JPanel( new GridLayout() );
        center.setBorder( BorderFactory.createEmptyBorder( 5, 10, 5, 10) );
        JTabbedPane pane = new JTabbedPane();
        JTextArea gpl = readLicense( GPL );
        JTextArea apache = readLicense( APACHE );
        JTextArea bsd = readLicense( BSD );
        JTextArea substance = readLicense( SUBSTANCE );

        JScrollPane scrollPane;
        scrollPane = new JScrollPane( gpl,
                        JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                        JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED );
        pane.add( scrollPane, "GNU General Public License" );
        scrollPane = new JScrollPane( apache,
                        JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                        JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED );
        pane.add( scrollPane, "The Apache Software License" );
        scrollPane = new JScrollPane( bsd,
                        JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                        JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED );
        pane.add( scrollPane, "PostgreSQL JDBC License" );
        scrollPane = new JScrollPane( substance,
                        JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                        JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED );
        pane.add( scrollPane, "Substance License" );
        center.add( pane );
        return center;
    }

    protected JTextArea readLicense( int type )
    {
        JTextArea area = null;
        URL source = null;
        switch( type )
        {
            case GPL:
                source = AboutBox.class.getResource( "/GPL-v2.txt" );
                break;
            case APACHE:
                source = AboutBox.class.getResource( "/LICENSE-2.0.txt" );
                break;
            case BSD:
                source = AboutBox.class.getResource( "/Postgres-BSD.txt" );
                break;
            case SUBSTANCE:
                source = AboutBox.class.getResource( "/Substance.license" );
                break;
        }

        if( source != null )
        {
            area = new JTextArea();
            try
            {
                BufferedReader reader = new BufferedReader( new InputStreamReader( source.openStream() ) );
                String line;
                while( (line = reader.readLine()) != null )
                {
                    area.append( line + "\n" );
                }
                area.setCaretPosition( 0 );
                reader.close();
            }
            catch( IOException e )
            {
                e.printStackTrace();
            }

        }
        return area;
    }

    // Overridden so we can exit when window is closed
    /***************************************************************************
     * Description of the Method
     * @param e Description of the Parameter
     **************************************************************************/
    protected void processWindowEvent( WindowEvent e )
    {
        if( e.getID() == WindowEvent.WINDOW_CLOSING )
        {
            cancel();
        }
        super.processWindowEvent( e );
    }

    // Close the dialog

    /***************************************************************************
     * Description of the Method
     **************************************************************************/
    void cancel()
    {
        dispose();
    }

    // Close the dialog on a button event

    /***************************************************************************
     * Description of the Method
     * @param e Description of the Parameter
     **************************************************************************/
    public void actionPerformed( ActionEvent e )
    {
        cancel();
    }
}
