; A statement ends with a semicolon, characters on a line after the semicolon are ignored
; lines starting with a semicolon are treated as comments

drop view if exists updatetimes;
drop table if exists configuration;
drop table if exists report;
drop table if exists blackhole;
drop table if exists planet;
drop table if exists player;
drop table if exists alliance;
drop table if exists account;

create table configuration (
    MAINFRAMEWIDTH  INT,
    MAINFRAMEHEIGHT INT,
    SHOWGALAXY      BOOLEAN,
    DATATRANSFER    VARCHAR(20),
    FONTNAME        VARCHAR(100),
    FONTSIZE        INT,
    LAFSTYLE        VARCHAR(50)
);

create table account (
    ID          BIGSERIAL NOT NULL PRIMARY KEY,
    NAME        VARCHAR(50) UNIQUE,
	ISDEFAULT	BOOLEAN,
	SEQUENCE	INT,
    LANGUAGE    VARCHAR(20),
    FLAVOR      VARCHAR(20),
    ISOUTPOST   BOOLEAN
);

create table alliance (
    ID          BIGSERIAL NOT NULL PRIMARY KEY,
    ACCOUNT     BIGINT NOT NULL,
	ALLIANCEID	BIGINT NOT NULL,
    NAME        VARCHAR(255),
	TAG			VARCHAR(30),
    UPDATETIME  BIGINT,
	NOTES		TEXT,
    FOREIGN KEY(ACCOUNT) REFERENCES account(ID) ON DELETE CASCADE
);

create unique index allianceIndex on alliance (ACCOUNT, ALLIANCEID);
create index allianceNameIndex on alliance (NAME);
create index tagIndex on alliance (TAG);

create table blackhole (
    ID          BIGSERIAL NOT NULL PRIMARY KEY,
    ACCOUNT     BIGINT NOT NULL,
    POSITION    INT NOT NULL,
    UPDATETIME  BIGINT,
    SETUP       BOOLEAN,
    LEVEL       INT,
    ATTACKED    BOOLEAN,
    UPGRADE     BIGINT,
    POWER       BIGINT,
    SHIPS       TEXT,
    SPICE       BIGINT,
    EMBLEMS     BIGINT,
    STARS       BIGINT,
    FOREIGN KEY(ACCOUNT) REFERENCES account(ID) ON DELETE CASCADE
);

create unique index blackHoleIndex on blackhole (POSITION, ACCOUNT);
create index blackHoleTimeIndex on blackhole (UPDATETIME);

create table player (
    ID              BIGSERIAL NOT NULL PRIMARY KEY,
    ACCOUNT         BIGINT NOT NULL,
    NAME            VARCHAR(255),
    TITLE           TEXT,
	PLAYERID        BIGINT NOT NULL,
    ALLIANCE        BIGINT,
    SPECIALIZATION  VARCHAR(255),
    POINTS          BIGINT,
    SPICE           BIGINT,
    UPDATETIME      BIGINT,
	STATUS          VARCHAR(20),
	SECSTATUS       VARCHAR(20),
	NOTES           TEXT,
    FOREIGN KEY(ACCOUNT) REFERENCES account(ID) ON DELETE CASCADE,
    FOREIGN KEY(ALLIANCE) REFERENCES alliance(ID) ON DELETE CASCADE
);

create unique index playerIndex on player (ACCOUNT, PLAYERID);
create index playerNameIndex on player (NAME);
create index pointIndex on player (POINTS);

create table planet (
    ID          BIGSERIAL NOT NULL PRIMARY KEY,
    ACCOUNT     BIGINT NOT NULL,
    NAME        VARCHAR(255),
    POSITION    INT NOT NULL,
	HASASTEROID	BOOLEAN,
	EVENT		BOOLEAN,
    OWNER	    BIGINT,
    UPDATETIME  BIGINT,
	NOTES		TEXT,
    IRON		BIGINT,
    METAL		BIGINT,
    KRYPTONITE	BIGINT,
    SPICE		BIGINT,
    FOREIGN KEY(ACCOUNT) REFERENCES account(ID) ON DELETE CASCADE,
    FOREIGN KEY(OWNER) REFERENCES player(ID) ON DELETE CASCADE
);

create unique index planetIndex on planet (POSITION, ACCOUNT);
create index ownerIndex on planet (OWNER);
create index timeIndex on planet (UPDATETIME);

create table report (
    ID          BIGSERIAL NOT NULL PRIMARY KEY,
    KIND     	VARCHAR(10),
    ACCOUNT     BIGINT NOT NULL,
    CREATETIME  BIGINT NOT NULL,
    POSITION    INT NOT NULL,
	ISASTEROID	BOOLEAN,
    PRIORITY   	VARCHAR(20),
	REPORTDATA	TEXT,
	NOTES		TEXT,
    ATTACKER    VARCHAR(100),
    DEFENDER    VARCHAR(100),
    PLANET      VARCHAR(100),
    FOREIGN KEY(ACCOUNT) REFERENCES account(ID) ON DELETE CASCADE
);

create index reportIndex on report (POSITION, ACCOUNT, CREATETIME);

create view updatetimes as
select ACCOUNT, POSITION, UPDATETIME from planet
union 
select ACCOUNT, POSITION, UPDATETIME from blackhole;