/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.menu;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.HighlightPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstanceMenuBackgroundDelegate {
    public static void paintBackground(Graphics graphics, Component component, int n) {
        if (!component.isShowing()) {
            return;
        }
        int n2 = component.getWidth();
        int n3 = component.getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        BackgroundPaintingUtils.update(graphics2D, component, false);
        if (n == 0) {
            return;
        }
        if (component.getParent() instanceof JPopupMenu) {
            if (component.getComponentOrientation().isLeftToRight()) {
                SubstanceConstants.MenuGutterFillKind menuGutterFillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
                if (menuGutterFillKind != SubstanceConstants.MenuGutterFillKind.NONE) {
                    SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(component, ComponentState.ENABLED);
                    Color color = menuGutterFillKind == SubstanceConstants.MenuGutterFillKind.SOFT_FILL || menuGutterFillKind == SubstanceConstants.MenuGutterFillKind.HARD ? substanceColorScheme.getUltraLightColor() : substanceColorScheme.getLightColor();
                    Color color2 = menuGutterFillKind == SubstanceConstants.MenuGutterFillKind.SOFT_FILL || menuGutterFillKind == SubstanceConstants.MenuGutterFillKind.SOFT ? substanceColorScheme.getUltraLightColor() : substanceColorScheme.getLightColor();
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(0.0f, 0.0f, n, 0.0f, new float[]{0.0f, 1.0f}, new Color[]{color, color2}, MultipleGradientPaint.CycleMethod.REPEAT);
                    graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite(component, 0.7f, graphics));
                    graphics2D.setPaint(linearGradientPaint);
                    graphics2D.fillRect(0, 0, n - 2, n3);
                }
            } else {
                SubstanceConstants.MenuGutterFillKind menuGutterFillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
                if (menuGutterFillKind != SubstanceConstants.MenuGutterFillKind.NONE) {
                    SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(component, ComponentState.ENABLED);
                    Color color = menuGutterFillKind == SubstanceConstants.MenuGutterFillKind.HARD_FILL || menuGutterFillKind == SubstanceConstants.MenuGutterFillKind.HARD ? substanceColorScheme.getLightColor() : substanceColorScheme.getUltraLightColor();
                    Color color3 = menuGutterFillKind == SubstanceConstants.MenuGutterFillKind.HARD_FILL || menuGutterFillKind == SubstanceConstants.MenuGutterFillKind.SOFT ? substanceColorScheme.getLightColor() : substanceColorScheme.getUltraLightColor();
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(n, 0.0f, n2, 0.0f, new float[]{0.0f, 1.0f}, new Color[]{color, color3}, MultipleGradientPaint.CycleMethod.REPEAT);
                    graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite(component, 0.7f, graphics));
                    graphics2D.setPaint(linearGradientPaint);
                    graphics2D.fillRect(n - 2, 0, n2, n3);
                }
            }
        }
        graphics2D.dispose();
    }

    public static void paintHighlights(Graphics graphics, JMenuItem jMenuItem, float f) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)jMenuItem.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        ComponentState componentState = modelStateInfo.getCurrModelStateNoSelection();
        if (componentState.isDisabled()) {
            return;
        }
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateNoSelectionContributionMap();
        if (componentState == ComponentState.ENABLED && map.size() == 1) {
            return;
        }
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
            ComponentState componentState2 = entry.getKey();
            float f2 = SubstanceColorSchemeUtilities.getHighlightAlpha(jMenuItem, componentState2) * entry.getValue().getContribution();
            if (f2 == 0.0f) continue;
            SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jMenuItem, ColorSchemeAssociationKind.HIGHLIGHT, componentState2);
            SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(jMenuItem, ColorSchemeAssociationKind.HIGHLIGHT_BORDER, componentState2);
            graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite(jMenuItem, f2, graphics));
            HighlightPainterUtils.paintHighlight(graphics2D, null, jMenuItem, new Rectangle(0, 0, jMenuItem.getWidth(), jMenuItem.getHeight()), f, null, substanceColorScheme, substanceColorScheme2);
            graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)jMenuItem, graphics));
        }
        graphics2D.dispose();
    }
}

