/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.icon;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.icon.TransitionAware;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;

@TransitionAware
public class ArrowButtonTransitionAwareIcon
implements Icon {
    private static LazyResettableHashMap<Icon> iconMap = new LazyResettableHashMap("ButtonArrowTransitionAwareIcon");
    private int orientation;
    protected int iconWidth;
    protected int iconHeight;
    protected TransitionAwareIcon.Delegate delegate;
    protected JComponent component;
    private TransitionAwareIcon.TransitionAwareUIDelegate transitionAwareUIDelegate;

    public ArrowButtonTransitionAwareIcon(final AbstractButton abstractButton, int n) {
        this(abstractButton, new TransitionAwareIcon.TransitionAwareUIDelegate(){

            @Override
            public TransitionAwareUI getTransitionAwareUI() {
                return (TransitionAwareUI)((Object)abstractButton.getUI());
            }
        }, n);
    }

    public ArrowButtonTransitionAwareIcon(final JComponent jComponent, TransitionAwareIcon.TransitionAwareUIDelegate transitionAwareUIDelegate, final int n) {
        this.component = jComponent;
        this.transitionAwareUIDelegate = transitionAwareUIDelegate;
        this.orientation = n;
        this.delegate = new TransitionAwareIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                int n2 = SubstanceSizeUtils.getComponentFontSize(jComponent);
                return SubstanceImageCreator.getArrowIcon(n2, n, substanceColorScheme);
            }
        };
        this.iconWidth = this.delegate.getColorSchemeIcon(SubstanceColorSchemeUtilities.getColorScheme(jComponent, ComponentState.ENABLED)).getIconWidth();
        this.iconHeight = this.delegate.getColorSchemeIcon(SubstanceColorSchemeUtilities.getColorScheme(jComponent, ComponentState.ENABLED)).getIconHeight();
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.getIconToPaint().paintIcon(component, graphics, n, n2);
    }

    private Icon getIconToPaint() {
        Object object;
        Object object2;
        boolean bl = this.component instanceof JMenu;
        StateTransitionTracker stateTransitionTracker = this.transitionAwareUIDelegate.getTransitionAwareUI().getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = bl ? modelStateInfo.getStateNoSelectionContributionMap() : modelStateInfo.getStateContributionMap();
        ComponentState componentState = bl ? modelStateInfo.getCurrModelStateNoSelection() : modelStateInfo.getCurrModelState();
        ColorSchemeAssociationKind colorSchemeAssociationKind = bl && componentState.isFacetActive(ComponentStateFacet.ROLLOVER) ? ColorSchemeAssociationKind.HIGHLIGHT : ColorSchemeAssociationKind.MARK;
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.component, colorSchemeAssociationKind, componentState);
        float f = SubstanceColorSchemeUtilities.getAlpha(this.component, componentState);
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(this.component.getClass().getName(), this.orientation, SubstanceSizeUtils.getComponentFontSize(this.component), substanceColorScheme.getDisplayName(), Float.valueOf(f));
        Icon icon = iconMap.get(hashMapKey);
        if (icon == null) {
            object2 = this.delegate.getColorSchemeIcon(substanceColorScheme);
            if (f == 1.0f) {
                icon = object2;
                iconMap.put(hashMapKey, icon);
            } else {
                object = SubstanceCoreUtilities.getBlankImage(object2.getIconWidth(), object2.getIconHeight());
                Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
                graphics2D.setComposite(AlphaComposite.SrcOver.derive(f));
                object2.paintIcon(this.component, graphics2D, 0, 0);
                graphics2D.dispose();
                icon = new ImageIcon((Image)object);
                iconMap.put(hashMapKey, icon);
            }
        }
        if (componentState.isDisabled() || map.size() == 1) {
            return icon;
        }
        object2 = SubstanceCoreUtilities.getBlankImage(icon.getIconWidth(), icon.getIconHeight());
        object = ((BufferedImage)object2).createGraphics();
        icon.paintIcon(this.component, (Graphics)object, 0, 0);
        for (Map.Entry entry : map.entrySet()) {
            float f2;
            ComponentState componentState2 = (ComponentState)entry.getKey();
            if (componentState2 == componentState || !((f2 = ((StateTransitionTracker.StateContributionInfo)entry.getValue()).getContribution()) > 0.0f)) continue;
            ((Graphics2D)object).setComposite(AlphaComposite.SrcOver.derive(f2));
            ColorSchemeAssociationKind colorSchemeAssociationKind2 = bl && componentState2.isFacetActive(ComponentStateFacet.ROLLOVER) ? ColorSchemeAssociationKind.HIGHLIGHT : ColorSchemeAssociationKind.MARK;
            SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(this.component, colorSchemeAssociationKind2, componentState2);
            float f3 = SubstanceColorSchemeUtilities.getAlpha(this.component, componentState2);
            HashMapKey hashMapKey2 = SubstanceCoreUtilities.getHashKey(this.component.getClass().getName(), this.orientation, SubstanceSizeUtils.getComponentFontSize(this.component), substanceColorScheme2.getDisplayName(), Float.valueOf(f3));
            Icon icon2 = iconMap.get(hashMapKey2);
            if (icon2 == null) {
                Icon icon3 = this.delegate.getColorSchemeIcon(substanceColorScheme2);
                if (f3 == 1.0f) {
                    icon2 = icon3;
                    iconMap.put(hashMapKey2, icon2);
                } else {
                    BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(icon3.getIconWidth(), icon3.getIconHeight());
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.setComposite(AlphaComposite.SrcOver.derive(f3));
                    icon3.paintIcon(this.component, graphics2D, 0, 0);
                    graphics2D.dispose();
                    icon2 = new ImageIcon(bufferedImage);
                    iconMap.put(hashMapKey2, icon2);
                }
            }
            icon2.paintIcon(this.component, (Graphics)object, 0, 0);
        }
        ((Graphics)object).dispose();
        return new ImageIcon((Image)object2);
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }
}

