/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.border;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.ui.SubstanceTableUI;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceTableCellBorder
implements Border,
UIResource {
    protected Insets myInsets;
    protected SubstanceTableUI ui;
    protected SubstanceTableUI.TableCellId cellId;
    protected float alpha;
    private static LazyResettableHashMap<BufferedImage> smallImageCache = new LazyResettableHashMap("SubstanceTableCellBorder");

    public SubstanceTableCellBorder(Insets insets, SubstanceTableUI substanceTableUI, SubstanceTableUI.TableCellId tableCellId) {
        this.myInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        this.ui = substanceTableUI;
        this.cellId = tableCellId;
        this.alpha = 1.0f;
    }

    private void paintBorder(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        ComponentState componentState;
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        float f = 0.0f;
        StateTransitionTracker stateTransitionTracker = this.ui.getStateTransitionTracker(this.cellId);
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker == null ? null : stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo == null ? null : modelStateInfo.getStateContributionMap();
        ComponentState componentState2 = componentState = modelStateInfo == null ? this.ui.getCellState(this.cellId) : modelStateInfo.getCurrModelState();
        if (componentState.isDisabled()) {
            componentState = ComponentState.DISABLED_SELECTED;
        }
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jComponent, ColorSchemeAssociationKind.HIGHLIGHT_BORDER, componentState);
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(SubstanceSizeUtils.getComponentFontSize(jComponent), n3, n4, Float.valueOf(f), substanceColorScheme.getDisplayName());
        BufferedImage bufferedImage = smallImageCache.get(hashMapKey);
        float f2 = SubstanceColorSchemeUtilities.getAlpha(jComponent, componentState);
        if (bufferedImage == null) {
            bufferedImage = SubstanceCoreUtilities.getBlankImage(n3, n4);
            Graphics2D graphics2D2 = bufferedImage.createGraphics();
            SubstanceImageCreator.paintBorder(jComponent, graphics2D2, 0, 0, n3, n4, f, substanceColorScheme);
            graphics2D2.dispose();
            smallImageCache.put(hashMapKey, bufferedImage);
        }
        graphics2D.setComposite(AlphaComposite.SrcOver.derive(f2 * this.alpha));
        graphics2D.drawImage((Image)bufferedImage, n, n2, null);
        if (!componentState.isDisabled() && map != null && map.size() > 1) {
            for (Map.Entry entry : map.entrySet()) {
                float f3;
                ComponentState componentState3 = (ComponentState)entry.getKey();
                if (componentState3 == componentState || (f3 = ((StateTransitionTracker.StateContributionInfo)entry.getValue()).getContribution()) == 0.0f) continue;
                SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(jComponent, ColorSchemeAssociationKind.HIGHLIGHT_BORDER, componentState3);
                HashMapKey hashMapKey2 = SubstanceCoreUtilities.getHashKey(SubstanceSizeUtils.getComponentFontSize(jComponent), n3, n4, Float.valueOf(f), substanceColorScheme2.getDisplayName());
                BufferedImage bufferedImage2 = smallImageCache.get(hashMapKey2);
                float f4 = SubstanceColorSchemeUtilities.getAlpha(jComponent, componentState3);
                if (bufferedImage2 == null) {
                    bufferedImage2 = SubstanceCoreUtilities.getBlankImage(n3, n4);
                    Graphics2D graphics2D3 = bufferedImage2.createGraphics();
                    SubstanceImageCreator.paintBorder(jComponent, graphics2D3, 0, 0, n3, n4, f, substanceColorScheme2);
                    graphics2D3.dispose();
                    smallImageCache.put(hashMapKey2, bufferedImage2);
                }
                graphics2D.setComposite(AlphaComposite.SrcOver.derive(f4 * this.alpha * f3));
                graphics2D.drawImage((Image)bufferedImage2, n, n2, null);
            }
        }
        graphics2D.dispose();
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder((JComponent)component, graphics, n, n2, n3, n4, component.isEnabled(), component.hasFocus());
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.myInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }
}

