/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.border.Border;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceEtchedBorder
implements Border {
    public Color getHighlightColor(Component component) {
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(component, ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
        boolean bl = substanceColorScheme.isDark();
        Color color = bl ? substanceColorScheme.getExtraLightColor() : SubstanceColorUtilities.getInterpolatedColor(substanceColorScheme.getMidColor(), substanceColorScheme.getDarkColor(), 0.4);
        return SubstanceColorUtilities.getAlphaColor(color, 196);
    }

    public Color getShadowColor(Component component) {
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(component, ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
        Color color = substanceColorScheme.isDark() ? substanceColorScheme.getDarkColor() : substanceColorScheme.getUltraLightColor();
        return SubstanceColorUtilities.getAlphaColor(color, 196);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n3;
        int n6 = n4;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        float f = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(component));
        graphics2D.setStroke(new BasicStroke(f, 0, 1));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(n, n2);
        graphics2D.setColor(this.getShadowColor(component));
        int n7 = (int)Math.floor((double)f / 2.0);
        graphics2D.draw(new Rectangle2D.Float(n7, n7, (float)(n5 - n7) - 2.0f * f, (float)(n6 - n7) - 2.0f * f));
        graphics2D.setColor(this.getHighlightColor(component));
        graphics2D.draw(new Line2D.Float(f, (float)n6 - 3.0f * f, f, f));
        graphics2D.draw(new Line2D.Float((float)n7 + f, (float)n7 + f, (float)(n5 - n7) - 3.0f * f, (float)n7 + f));
        graphics2D.draw(new Line2D.Float(n7, (float)(n6 - n7) - f, (float)(n5 - n7) - f, (float)(n6 - n7) - f));
        graphics2D.draw(new Line2D.Float((float)(n5 - n7) - f, (float)(n6 - n7) - f, (float)(n5 - n7) - f, n7));
        graphics2D.dispose();
        RenderingUtils.installDesktopHints((Graphics2D)graphics, component);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        float f = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(component));
        int n = (int)Math.ceil(2.0 * (double)f);
        return new Insets(n, n, n, n);
    }
}

