/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

class SoftHashMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private final Map<K, KeySoftReference<K, V>> hash = new HashMap<K, KeySoftReference<K, V>>();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    SoftHashMap() {
    }

    @Override
    public V get(Object object) {
        this.expungeStaleEntries();
        V v = null;
        KeySoftReference<K, V> keySoftReference = this.hash.get(object);
        if (keySoftReference != null && (v = (V)keySoftReference.get()) == null) {
            this.hash.remove(object);
        }
        return v;
    }

    private void expungeStaleEntries() {
        Reference<V> reference;
        while ((reference = this.queue.poll()) != null) {
            KeySoftReference keySoftReference = (KeySoftReference)reference;
            this.hash.remove(keySoftReference.key);
        }
    }

    @Override
    public V put(K k, V v) {
        this.expungeStaleEntries();
        KeySoftReference<K, V> keySoftReference = new KeySoftReference<K, V>(k, v, this.queue);
        SoftReference softReference = this.hash.put(k, keySoftReference);
        if (softReference == null) {
            return null;
        }
        return (V)softReference.get();
    }

    @Override
    public V remove(Object object) {
        this.expungeStaleEntries();
        SoftReference softReference = this.hash.remove(object);
        if (softReference == null) {
            return null;
        }
        return (V)softReference.get();
    }

    @Override
    public void clear() {
        this.hash.clear();
    }

    @Override
    public int size() {
        this.expungeStaleEntries();
        return this.hash.size();
    }

    @Override
    public boolean containsKey(Object object) {
        this.expungeStaleEntries();
        SoftReference softReference = this.hash.get(object);
        if (softReference != null) {
            Object t = softReference.get();
            if (t != null) {
                return true;
            }
            this.hash.remove(object);
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.expungeStaleEntries();
        LinkedHashSet<Map.Entry<K, V>> linkedHashSet = new LinkedHashSet<Map.Entry<K, V>>();
        for (final Map.Entry<K, KeySoftReference<K, V>> entry : this.hash.entrySet()) {
            final Object t = entry.getValue().get();
            if (t == null) continue;
            linkedHashSet.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return entry.getKey();
                }

                @Override
                public V getValue() {
                    return t;
                }

                @Override
                public V setValue(V v) {
                    entry.setValue(new KeySoftReference(entry.getKey(), v, SoftHashMap.this.queue));
                    return t;
                }
            });
        }
        return linkedHashSet;
    }

    public static class KeySoftReference<K, V>
    extends SoftReference<V> {
        final K key;

        public KeySoftReference(K k, V v, ReferenceQueue<V> referenceQueue) {
            super(v, referenceQueue);
            this.key = k;
        }
    }
}

