/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.security.AccessControlException;
import javax.swing.AbstractButton;
import javax.swing.plaf.basic.BasicButtonListener;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.utils.SubstanceInternalFrameTitlePane;

public class RolloverButtonListener
extends BasicButtonListener {
    private boolean isMouseInside;
    private AbstractButton button;
    private StateTransitionTracker stateTransitionTracker;

    public RolloverButtonListener(AbstractButton abstractButton, StateTransitionTracker stateTransitionTracker) {
        super(abstractButton);
        this.button = abstractButton;
        this.isMouseInside = false;
        this.stateTransitionTracker = stateTransitionTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            boolean bl;
            super.mouseEntered(mouseEvent);
            this.isMouseInside = true;
            boolean bl2 = bl = (mouseEvent.getModifiersEx() & 0x400) != 0;
            if (!bl) {
                this.button.getModel().setRollover(true);
            }
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.mouseExited(mouseEvent);
            this.isMouseInside = false;
            this.button.getModel().setRollover(false);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.mouseReleased(mouseEvent);
            for (ActionListener actionListener : this.button.getActionListeners()) {
                if (!(actionListener instanceof SubstanceInternalFrameTitlePane.ClickListener)) continue;
                return;
            }
            this.button.getModel().setRollover(this.isMouseInside);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.mouseMoved(mouseEvent);
            for (ActionListener actionListener : this.button.getActionListeners()) {
                if (!(actionListener instanceof SubstanceInternalFrameTitlePane.ClickListener)) continue;
                return;
            }
            this.button.getModel().setRollover(this.isMouseInside);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.focusGained(focusEvent);
            if (!this.button.isShowing()) {
                return;
            }
            try {
                PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                int n = pointerInfo.getLocation().x - this.button.getLocationOnScreen().x;
                int n2 = pointerInfo.getLocation().y - this.button.getLocationOnScreen().y;
                this.button.getModel().setRollover(this.button.contains(n, n2));
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.focusLost(focusEvent);
            this.button.getModel().setRollover(false);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.mouseClicked(mouseEvent);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.mouseDragged(mouseEvent);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.mousePressed(mouseEvent);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }
}

